/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.blockloader.docvalues.fn;

import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.AbstractDoublesFromDocValuesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.fn.MvMaxLongsFromDocValuesBlockLoader;

public class MvMaxDoublesFromDocValuesBlockLoader
extends AbstractDoublesFromDocValuesBlockLoader {
    public MvMaxDoublesFromDocValuesBlockLoader(String fieldName, BlockDocValuesReader.ToDouble toDouble) {
        super(fieldName, toDouble);
    }

    @Override
    protected BlockLoader.AllReader singletonReader(NumericDocValues docValues, BlockDocValuesReader.ToDouble toDouble) {
        return new AbstractDoublesFromDocValuesBlockLoader.Singleton(docValues, toDouble);
    }

    @Override
    protected BlockLoader.AllReader sortedReader(SortedNumericDocValues docValues, BlockDocValuesReader.ToDouble toDouble) {
        return new MvMaxSorted(docValues, toDouble);
    }

    public String toString() {
        return "DoublesFromDocValues[" + this.fieldName + "]";
    }

    private static class MvMaxSorted
    extends BlockDocValuesReader {
        private final SortedNumericDocValues numericDocValues;
        private final BlockDocValuesReader.ToDouble toDouble;

        MvMaxSorted(SortedNumericDocValues numericDocValues, BlockDocValuesReader.ToDouble toDouble) {
            this.numericDocValues = numericDocValues;
            this.toDouble = toDouble;
        }

        @Override
        public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
            try (BlockLoader.DoubleBuilder builder = factory.doublesFromDocValues(docs.count() - offset);){
                for (int i = offset; i < docs.count(); ++i) {
                    int doc = docs.get(i);
                    this.read(doc, builder);
                }
                BlockLoader.Block block = builder.build();
                return block;
            }
        }

        @Override
        public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
            this.read(docId, (BlockLoader.DoubleBuilder)builder);
        }

        private void read(int doc, BlockLoader.DoubleBuilder builder) throws IOException {
            if (!this.numericDocValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            MvMaxLongsFromDocValuesBlockLoader.discardAllButLast(this.numericDocValues);
            builder.appendDouble(this.toDouble.convert(this.numericDocValues.nextValue()));
        }

        @Override
        public int docId() {
            return this.numericDocValues.docID();
        }

        @Override
        public String toString() {
            return "MvMaxDoublesFromDocValues.Sorted";
        }
    }
}

