/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.deprecation.DeprecatedIndexPredicate;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.ResourceDeprecationChecker;
import org.elasticsearch.xpack.deprecation.TransportDeprecationInfoAction;

public class DataStreamDeprecationChecker
implements ResourceDeprecationChecker {
    public static final String NAME = "data_streams";
    private static final List<BiFunction<DataStream, ProjectMetadata, DeprecationIssue>> DATA_STREAM_CHECKS = List.of(DataStreamDeprecationChecker::oldIndicesCheck, DataStreamDeprecationChecker::ignoredOldIndicesCheck);
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public DataStreamDeprecationChecker(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    public Map<String, List<DeprecationIssue>> check(ProjectMetadata project, DeprecationInfoAction.Request request, TransportDeprecationInfoAction.PrecomputedData precomputedData) {
        return this.check(project);
    }

    public Map<String, List<DeprecationIssue>> check(ProjectMetadata project) {
        List dataStreamNames = this.indexNameExpressionResolver.dataStreamNames(project, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN, new String[0]);
        if (dataStreamNames.isEmpty()) {
            return Map.of();
        }
        HashMap<String, List<DeprecationIssue>> dataStreamIssues = new HashMap<String, List<DeprecationIssue>>();
        for (String dataStreamName : dataStreamNames) {
            List<DeprecationIssue> issuesForSingleDataStream;
            DataStream dataStream = (DataStream)project.dataStreams().get(dataStreamName);
            if (dataStream.isSystem() || (issuesForSingleDataStream = DATA_STREAM_CHECKS.stream().map(c -> (DeprecationIssue)c.apply(dataStream, project)).filter(Objects::nonNull).toList()).isEmpty()) continue;
            dataStreamIssues.put(dataStreamName, issuesForSingleDataStream);
        }
        return dataStreamIssues.isEmpty() ? Map.of() : dataStreamIssues;
    }

    static DeprecationIssue oldIndicesCheck(DataStream dataStream, ProjectMetadata project) {
        List backingIndices = dataStream.getIndices();
        Set<String> percolatorIndicesNeedingUpgrade = DataStreamDeprecationChecker.getReindexRequiredIndicesWithPercolatorFields(backingIndices, project, false);
        if (!percolatorIndicesNeedingUpgrade.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Field mappings with incompatible percolator type", "https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/percolator#_reindexing_your_percolator_queries", "The data stream was created before 9.latest and contains mappings that must be reindexed due to containing percolator fields.", false, Map.ofEntries(Map.entry("reindex_required", true), Map.entry("excluded_actions", List.of("readOnly")), Map.entry("total_backing_indices", backingIndices.size()), Map.entry("indices_requiring_upgrade_count", percolatorIndicesNeedingUpgrade.size()), Map.entry("indices_requiring_upgrade", percolatorIndicesNeedingUpgrade)));
        }
        Set<String> indicesNeedingUpgrade = DataStreamDeprecationChecker.getReindexRequiredIndices(backingIndices, project, false);
        if (!indicesNeedingUpgrade.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Old data stream with a compatibility version < " + Version.CURRENT.major + ".0", "https://ela.st/es-deprecation-ds-reindex", "This data stream has backing indices that were created before Elasticsearch " + Version.CURRENT.major + ".0", false, Map.ofEntries(Map.entry("reindex_required", true), Map.entry("total_backing_indices", backingIndices.size()), Map.entry("indices_requiring_upgrade_count", indicesNeedingUpgrade.size()), Map.entry("indices_requiring_upgrade", indicesNeedingUpgrade)));
        }
        return null;
    }

    static DeprecationIssue ignoredOldIndicesCheck(DataStream dataStream, ProjectMetadata project) {
        List backingIndices = dataStream.getIndices();
        Set<String> percolatorIgnoredIndices = DataStreamDeprecationChecker.getReindexRequiredIndicesWithPercolatorFields(backingIndices, project, true);
        if (!percolatorIgnoredIndices.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Field mappings with incompatible percolator type", "https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/percolator#_reindexing_your_percolator_queries", "The data stream was created before 9.latest and contains mappings that must be reindexed due to containing percolator fields.", false, Map.ofEntries(Map.entry("reindex_required", true), Map.entry("excluded_actions", List.of("readOnly")), Map.entry("total_backing_indices", backingIndices.size()), Map.entry("ignored_indices_requiring_upgrade_count", percolatorIgnoredIndices.size()), Map.entry("ignored_indices_requiring_upgrade", percolatorIgnoredIndices)));
        }
        Set<String> ignoredIndices = DataStreamDeprecationChecker.getReindexRequiredIndices(backingIndices, project, true);
        if (!ignoredIndices.isEmpty()) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Old data stream with a compatibility version < " + Version.CURRENT.major + ".0 has Been Ignored", "https://ela.st/es-deprecation-ds-reindex", "This data stream has read only backing indices that were created before Elasticsearch " + Version.CURRENT.major + ".0 and have been marked as OK to remain read-only after upgrade", false, Map.ofEntries(Map.entry("reindex_required", false), Map.entry("total_backing_indices", backingIndices.size()), Map.entry("ignored_indices_requiring_upgrade_count", ignoredIndices.size()), Map.entry("ignored_indices_requiring_upgrade", ignoredIndices)));
        }
        return null;
    }

    private static Set<String> getReindexRequiredIndices(List<Index> backingIndices, ProjectMetadata project, boolean filterToBlockedStatus) {
        return backingIndices.stream().filter(DeprecatedIndexPredicate.getReindexRequiredPredicate((ProjectMetadata)project, (boolean)filterToBlockedStatus, (boolean)false)).map(Index::getName).collect(Collectors.toUnmodifiableSet());
    }

    private static Set<String> getReindexRequiredIndicesWithPercolatorFields(List<Index> backingIndices, ProjectMetadata project, boolean filterToBlockedStatus) {
        return backingIndices.stream().filter(index -> !DeprecatedIndexPredicate.reindexRequiredForPecolatorFields((IndexMetadata)project.index(index), (boolean)filterToBlockedStatus, (boolean)false).isEmpty()).map(Index::getName).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public String getName() {
        return NAME;
    }
}

