/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.aggregatemetric.mapper;

import java.io.IOException;
import java.util.EnumMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.DoublesBlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.IntsBlockLoader;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateMetricDoubleFieldMapper;

public class AggregateMetricDoubleBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final DoublesBlockLoader minLoader;
    private final DoublesBlockLoader maxLoader;
    private final DoublesBlockLoader sumLoader;
    private final IntsBlockLoader countLoader;

    AggregateMetricDoubleBlockLoader(EnumMap<AggregateMetricDoubleFieldMapper.Metric, NumberFieldMapper.NumberFieldType> metricsRequested) {
        this.minLoader = AggregateMetricDoubleBlockLoader.getDoublesBlockLoader(AggregateMetricDoubleFieldMapper.Metric.min, metricsRequested);
        this.maxLoader = AggregateMetricDoubleBlockLoader.getDoublesBlockLoader(AggregateMetricDoubleFieldMapper.Metric.max, metricsRequested);
        this.sumLoader = AggregateMetricDoubleBlockLoader.getDoublesBlockLoader(AggregateMetricDoubleFieldMapper.Metric.sum, metricsRequested);
        this.countLoader = AggregateMetricDoubleBlockLoader.getIntsBlockLoader(AggregateMetricDoubleFieldMapper.Metric.value_count, metricsRequested);
    }

    private static DoublesBlockLoader getDoublesBlockLoader(AggregateMetricDoubleFieldMapper.Metric metric, EnumMap<AggregateMetricDoubleFieldMapper.Metric, NumberFieldMapper.NumberFieldType> metricsRequested) {
        if (!metricsRequested.containsKey((Object)metric)) {
            return null;
        }
        NumberFieldMapper.NumberFieldType toLoad = metricsRequested.get((Object)metric);
        return new DoublesBlockLoader(toLoad.name(), NumericUtils::sortableLongToDouble);
    }

    private static IntsBlockLoader getIntsBlockLoader(AggregateMetricDoubleFieldMapper.Metric metric, EnumMap<AggregateMetricDoubleFieldMapper.Metric, NumberFieldMapper.NumberFieldType> metricsRequested) {
        if (!metricsRequested.containsKey((Object)metric)) {
            return null;
        }
        NumberFieldMapper.NumberFieldType toLoad = metricsRequested.get((Object)metric);
        return new IntsBlockLoader(toLoad.name());
    }

    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        final BlockLoader.AllReader minReader = this.minLoader != null ? this.minLoader.reader(context) : null;
        final BlockLoader.AllReader maxReader = this.maxLoader != null ? this.maxLoader.reader(context) : null;
        final BlockLoader.AllReader sumReader = this.sumLoader != null ? this.sumLoader.reader(context) : null;
        final BlockLoader.AllReader countReader = this.countLoader != null ? this.countLoader.reader(context) : null;
        return new BlockLoader.AllReader(){

            public String toString() {
                return "BlockDocValuesReader.AggregateMetricDouble";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BlockLoader.Block read(BlockLoader.BlockFactory factory, BlockLoader.Docs docs, int offset, boolean nullsFiltered) throws IOException {
                BlockLoader.Block block;
                block3: {
                    boolean success = false;
                    BlockLoader.Block minBlock = null;
                    BlockLoader.Block maxBlock = null;
                    BlockLoader.Block sumBlock = null;
                    BlockLoader.Block countBlock = null;
                    try {
                        int count = docs.count() - offset;
                        minBlock = minReader != null ? minReader.read(factory, docs, offset, nullsFiltered) : factory.constantNulls(count);
                        maxBlock = maxReader != null ? maxReader.read(factory, docs, offset, nullsFiltered) : factory.constantNulls(count);
                        sumBlock = sumReader != null ? sumReader.read(factory, docs, offset, nullsFiltered) : factory.constantNulls(count);
                        countBlock = countReader != null ? countReader.read(factory, docs, offset, nullsFiltered) : factory.constantNulls(count);
                        BlockLoader.Block block2 = factory.buildAggregateMetricDoubleDirect(minBlock, maxBlock, sumBlock, countBlock);
                        success = true;
                        block = block2;
                        if (success) break block3;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            Releasables.closeExpectNoException((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock});
                        }
                        throw throwable;
                    }
                    Releasables.closeExpectNoException((Releasable[])new Releasable[]{minBlock, maxBlock, sumBlock, countBlock});
                }
                return block;
            }

            public void read(int docId, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder) throws IOException {
                BlockLoader.AggregateMetricDoubleBuilder blockBuilder = (BlockLoader.AggregateMetricDoubleBuilder)builder;
                this.readSingleRowFromSubblock(docId, storedFields, (BlockLoader.Builder)blockBuilder.min(), minReader);
                this.readSingleRowFromSubblock(docId, storedFields, (BlockLoader.Builder)blockBuilder.max(), maxReader);
                this.readSingleRowFromSubblock(docId, storedFields, (BlockLoader.Builder)blockBuilder.sum(), sumReader);
                this.readSingleRowFromSubblock(docId, storedFields, (BlockLoader.Builder)blockBuilder.count(), countReader);
            }

            private void readSingleRowFromSubblock(int docID, BlockLoader.StoredFields storedFields, BlockLoader.Builder builder, BlockLoader.AllReader reader) throws IOException {
                if (reader == null) {
                    builder.appendNull();
                } else {
                    reader.read(docID, storedFields, builder);
                }
            }

            public boolean canReuse(int startingDocID) {
                return !(minReader != null && !minReader.canReuse(startingDocID) || maxReader != null && !maxReader.canReuse(startingDocID) || sumReader != null && !sumReader.canReuse(startingDocID) || countReader != null && !countReader.canReuse(startingDocID));
            }
        };
    }

    public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.aggregateMetricDoubleBuilder(expectedCount);
    }
}

