/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SimpleBatchedExecutor;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.reservedstate.service.ReservedStateErrorTask;

class ReservedStateErrorTaskExecutor
extends SimpleBatchedExecutor<ReservedStateErrorTask, Void> {
    private static final Logger logger = LogManager.getLogger(ReservedStateErrorTaskExecutor.class);

    ReservedStateErrorTaskExecutor() {
    }

    @Override
    public Tuple<ClusterState, Void> executeTask(ReservedStateErrorTask task, ClusterState clusterState) {
        if (task.shouldUpdate(clusterState)) {
            return Tuple.tuple(task.execute(clusterState), null);
        }
        return Tuple.tuple(clusterState, null);
    }

    @Override
    public void taskSucceeded(ReservedStateErrorTask task, Void unused) {
        task.listener().onResponse(ActionResponse.Empty.INSTANCE);
    }

    @Override
    public void clusterStatePublished() {
        logger.debug("Wrote new error state in reserved cluster state metadata");
    }
}

