/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.HashSet;
import java.util.Set;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.WriteLoadConstraintSettings;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.gateway.GatewayService;

public class WriteLoadConstraintMonitor {
    private static final Logger logger = LogManager.getLogger(WriteLoadConstraintMonitor.class);
    private static final int MAX_NODE_IDS_IN_MESSAGE = 3;
    private final WriteLoadConstraintSettings writeLoadConstraintSettings;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final LongSupplier currentTimeMillisSupplier;
    private final RerouteService rerouteService;
    private volatile long lastRerouteTimeMillis = 0L;
    private volatile Set<String> lastSetOfHotSpottedNodes = Set.of();

    public WriteLoadConstraintMonitor(ClusterSettings clusterSettings, LongSupplier currentTimeMillisSupplier, Supplier<ClusterState> clusterStateSupplier, RerouteService rerouteService) {
        this.writeLoadConstraintSettings = new WriteLoadConstraintSettings(clusterSettings);
        this.clusterStateSupplier = clusterStateSupplier;
        this.currentTimeMillisSupplier = currentTimeMillisSupplier;
        this.rerouteService = rerouteService;
    }

    public void onNewInfo(ClusterInfo clusterInfo) {
        boolean haveCalledRerouteRecently;
        ClusterState state = this.clusterStateSupplier.get();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("skipping monitor as the cluster state is not recovered yet");
            return;
        }
        if (this.writeLoadConstraintSettings.getWriteLoadConstraintEnabled().notFullyEnabled()) {
            logger.debug("skipping monitor because the write load decider is not fully enabled");
            return;
        }
        logger.trace("processing new cluster info");
        int numberOfNodes = clusterInfo.getNodeUsageStatsForThreadPools().size();
        HashSet<String> nodeIdsExceedingLatencyThreshold = Sets.newHashSetWithExpectedSize(numberOfNodes);
        clusterInfo.getNodeUsageStatsForThreadPools().forEach((nodeId, usageStats) -> {
            NodeUsageStatsForThreadPools.ThreadPoolUsageStats writeThreadPoolStats = usageStats.threadPoolUsageStatsMap().get("write");
            assert (writeThreadPoolStats != null) : "Write thread pool is not publishing usage stats for node [" + nodeId + "]";
            if (writeThreadPoolStats.maxThreadPoolQueueLatencyMillis() > this.writeLoadConstraintSettings.getQueueLatencyThreshold().millis()) {
                nodeIdsExceedingLatencyThreshold.add((String)nodeId);
            }
        });
        if (nodeIdsExceedingLatencyThreshold.isEmpty()) {
            logger.debug("No hot-spotting nodes detected");
            return;
        }
        long currentTimeMillis = this.currentTimeMillisSupplier.getAsLong();
        long timeSinceLastRerouteMillis = currentTimeMillis - this.lastRerouteTimeMillis;
        boolean bl = haveCalledRerouteRecently = timeSinceLastRerouteMillis < this.writeLoadConstraintSettings.getMinimumRerouteInterval().millis();
        if (!haveCalledRerouteRecently || !Sets.difference(nodeIdsExceedingLatencyThreshold, this.lastSetOfHotSpottedNodes).isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Found {} exceeding the write thread pool queue latency threshold ({} total), triggering reroute", (Object)WriteLoadConstraintMonitor.nodeSummary(nodeIdsExceedingLatencyThreshold), (Object)state.nodes().size());
            }
            String reason = "hot-spotting detected by write load constraint monitor";
            this.rerouteService.reroute("hot-spotting detected by write load constraint monitor", Priority.NORMAL, ActionListener.wrap(ignored -> logger.trace("{} reroute successful", (Object)"hot-spotting detected by write load constraint monitor"), e -> logger.debug(() -> Strings.format("reroute failed, reason: %s", "hot-spotting detected by write load constraint monitor"), (Throwable)e)));
            this.lastRerouteTimeMillis = this.currentTimeMillisSupplier.getAsLong();
            this.lastSetOfHotSpottedNodes = nodeIdsExceedingLatencyThreshold;
        } else {
            logger.debug("Not calling reroute because we called reroute recently and there are no new hot spots");
        }
    }

    private static String nodeSummary(Set<String> nodeIds) {
        if (!nodeIds.isEmpty() && nodeIds.size() <= 3) {
            return "[" + String.join((CharSequence)", ", nodeIds) + "]";
        }
        return nodeIds.size() + " nodes";
    }
}

