/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.search.stats.FieldUsageStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FieldUsageShardResponse
implements Writeable,
ToXContentObject {
    final String trackingId;
    final ShardRouting shardRouting;
    final long trackingStartTime;
    final FieldUsageStats stats;

    FieldUsageShardResponse(StreamInput in) throws IOException {
        this.trackingId = in.readString();
        this.shardRouting = new ShardRouting(in);
        this.trackingStartTime = in.readVLong();
        this.stats = new FieldUsageStats(in);
    }

    FieldUsageShardResponse(String trackingId, ShardRouting shardRouting, long trackingStartTime, FieldUsageStats stats) {
        this.trackingId = Objects.requireNonNull(trackingId, "trackingId must be non null");
        this.shardRouting = Objects.requireNonNull(shardRouting, "routing must be non null");
        this.trackingStartTime = trackingStartTime;
        this.stats = Objects.requireNonNull(stats, "stats must be non null");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.trackingId);
        this.shardRouting.writeTo(out);
        out.writeVLong(this.trackingStartTime);
        this.stats.writeTo(out);
    }

    public String getTrackingId() {
        return this.trackingId;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public long getTrackingStartTime() {
        return this.trackingStartTime;
    }

    public FieldUsageStats getStats() {
        return this.stats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("tracking_id", this.trackingId);
        builder.timestampFieldsFromUnixEpochMillis("tracking_started_at_millis", "tracking_started_at", this.trackingStartTime);
        builder.startObject("routing").field("state", this.shardRouting.state()).field("primary", this.shardRouting.primary()).field("node", this.shardRouting.currentNodeId()).field("relocating_node", this.shardRouting.relocatingNodeId()).endObject();
        builder.field("stats", this.stats, params);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String TRACKING_ID = "tracking_id";
        static final String TRACKING_STARTED_AT_MILLIS = "tracking_started_at_millis";
        static final String TRACKING_STARTED_AT = "tracking_started_at";
        static final String STATS = "stats";
        static final String ROUTING = "routing";
        static final String STATE = "state";
        static final String PRIMARY = "primary";
        static final String NODE = "node";
        static final String RELOCATING_NODE = "relocating_node";

        Fields() {
        }
    }
}

