/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.logstashbridge.ingest.IngestDocumentBridge;
import org.elasticsearch.logstashbridge.ingest.PipelineBridge;
import org.elasticsearch.logstashbridge.ingest.PipelineConfigurationBridge;

public class IngestPipeline {
    private final PipelineConfigurationBridge pipelineConfiguration;
    private final PipelineBridge innerPipeline;

    IngestPipeline(PipelineConfigurationBridge pipelineConfiguration, PipelineBridge innerPipeline) {
        this.pipelineConfiguration = pipelineConfiguration;
        this.innerPipeline = innerPipeline;
    }

    public String getId() {
        return this.innerPipeline.getId();
    }

    public void execute(IngestDocumentBridge ingestDocument, BiConsumer<IngestDocumentBridge, Exception> handler) {
        ingestDocument.executePipeline(this.innerPipeline, handler);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestPipeline that = (IngestPipeline)o;
        return this.pipelineConfiguration.equals(that.pipelineConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.pipelineConfiguration);
    }

    public String toString() {
        return "IngestPipeline{id=" + this.getId() + "pipelineConfiguration=" + String.valueOf(this.pipelineConfiguration) + "}";
    }
}

