/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.DecimalValue;

public class CurrentGroup
extends SystemFunctionCall
implements Callable {
    private boolean is30 = false;
    private boolean isInLoop = false;
    private ItemType itemType = AnyItemType.getInstance();
    private ForEachGroup controllingInstruction = null;

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        this.is30 = visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE);
        super.checkArguments(visitor);
    }

    public void setControllingInstruction(ForEachGroup instruction, ItemType itemType, boolean isInLoop) {
        this.controllingInstruction = instruction;
        this.isInLoop = isInLoop;
        this.itemType = itemType;
    }

    public ForEachGroup getControllingInstruction() {
        return this.controllingInstruction;
    }

    public boolean isInLoop() {
        return this.isInLoop;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public int getIntrinsicDependencies() {
        return 32;
    }

    public int computeSpecialProperties() {
        if (this.controllingInstruction == null) {
            return 0;
        }
        return this.controllingInstruction.getSelectExpression().getSpecialProperties();
    }

    public Expression copy() {
        CurrentGroup cg = (CurrentGroup)super.copy();
        cg.is30 = this.is30;
        cg.isInLoop = this.isInLoop;
        cg.itemType = this.itemType;
        cg.controllingInstruction = this.controllingInstruction;
        return cg;
    }

    public SequenceIterator iterate(XPathContext c) throws XPathException {
        GroupIterator gi = c.getCurrentGroupIterator();
        if (gi == null || !gi.hasCurrentGroup()) {
            if (this.is30) {
                XPathException err = new XPathException("There is no current group", "XTDE1061");
                err.setLocator(this);
                throw err;
            }
            return EmptyIterator.emptyIterator();
        }
        return gi.iterateCurrentGroup();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(this.iterate(context));
    }
}

