"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformReferencesOut = transformReferencesOut;
var _common = require("../../../../common");
var _kibana_services = require("../../../kibana_services");
var _reference_utils = require("../../../../common/reference_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformReferencesOut(references, panels) {
  // key: panel uid
  // value: boolean indicating to drop references for panel
  // because transformOut injected references serverside
  // TODO - remove when all references are handled on server
  const dropRefsForPanel = {};
  function setDropRefsForPanel(panel) {
    var _embeddableService$ge;
    if (!panel.uid) return;
    const {
      transformOutInjectsReferences
    } = (_embeddableService$ge = _kibana_services.embeddableService === null || _kibana_services.embeddableService === void 0 ? void 0 : _kibana_services.embeddableService.getTransforms(panel.type)) !== null && _embeddableService$ge !== void 0 ? _embeddableService$ge : {};
    dropRefsForPanel[panel.uid] = Boolean(transformOutInjectsReferences);
  }
  (panels !== null && panels !== void 0 ? panels : []).forEach(panel => {
    if ((0, _common.isDashboardSection)(panel)) {
      panel.panels.forEach(panelInSection => setDropRefsForPanel(panelInSection));
    } else {
      setDropRefsForPanel(panel);
    }
  });
  return references.map(ref => {
    return isLegacySavedObjectRef(ref) ? transformLegacySavedObjectRef(ref) : ref;
  }).filter(ref => {
    const panelId = (0, _reference_utils.getPanelIdFromReference)(ref);
    return panelId && dropRefsForPanel[panelId] ?
    // drop references for panels that inject references on server
    false : true;
  });
}

// < 9.2 legach saved object ref name shape `${panelId}:panel_${panelId}`
const LEGACY_SAVED_OBJECT_REF_NAME_PREFIX = 'panel_';
function isLegacySavedObjectRef(ref) {
  return ref.name.includes(LEGACY_SAVED_OBJECT_REF_NAME_PREFIX);
}
function transformLegacySavedObjectRef(ref) {
  const split = ref.name.split(LEGACY_SAVED_OBJECT_REF_NAME_PREFIX);
  const panelId = split.length >= 2 ? split[1] : undefined;
  return {
    ...ref,
    name: panelId ? `${panelId}:savedObjectRef` : 'savedObjectRef'
  };
}