"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerReadRoute = registerReadRoute;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _schemas = require("./schemas");
var _read = require("./read");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerReadRoute(router) {
  const readRoute = router.get({
    path: `${_constants.PUBLIC_API_PATH}/{id}`,
    summary: `Get a dashboard`,
    ..._constants.commonRouteConfig
  });
  readRoute.addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: () => ({
      request: {
        params: _configSchema.schema.object({
          id: _configSchema.schema.string({
            meta: {
              description: 'A unique identifier for the dashboard.'
            }
          })
        })
      },
      response: {
        200: {
          body: _schemas.getReadResponseBodySchema
        }
      }
    })
  }, async (ctx, req, res) => {
    try {
      const result = await (0, _read.read)(ctx, req.params.id);
      return res.ok({
        body: result
      });
    } catch (e) {
      if (e.isBoom && e.output.statusCode === 404) {
        return res.notFound({
          body: {
            message: `A dashboard with ID ${req.params.id}] was not found.`
          }
        });
      }
      if (e.isBoom && e.output.statusCode === 403) {
        return res.forbidden();
      }
      return res.badRequest(e.message);
    }
  });
}