"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmDiscardUnsavedChanges = exports.confirmCreateWithUnsaved = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_services = require("../services/kibana_services");
var _dashboard_listing_strings = require("./_dashboard_listing_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_listing/confirm_overlays.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const confirmDiscardUnsavedChanges = (discardCallback, viewMode = 'edit' // we want to show the danger modal on the listing page
) => {
  _kibana_services.coreServices.overlays.openConfirm(_dashboard_listing_strings.resetConfirmStrings.getResetSubtitle(viewMode), {
    confirmButtonText: _dashboard_listing_strings.resetConfirmStrings.getResetConfirmButtonText(),
    buttonColor: viewMode === 'edit' ? 'danger' : 'primary',
    maxWidth: 500,
    defaultFocusedButton: _eui.EUI_MODAL_CANCEL_BUTTON,
    title: _dashboard_listing_strings.resetConfirmStrings.getResetTitle()
  }).then(isConfirmed => {
    if (isConfirmed) {
      discardCallback();
    }
  });
};
exports.confirmDiscardUnsavedChanges = confirmDiscardUnsavedChanges;
const confirmCreateWithUnsaved = (startBlankCallback, continueCallback) => {
  const titleId = 'confirmDiscardOrKeepTitle';
  const descriptionId = 'confirmDiscardOrKeepDescription';
  const session = _kibana_services.coreServices.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    clickOutsideDisables: true,
    initialFocus: '.dashboardCreateConfirmContinueButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: () => session.close(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    role: "dialog",
    "aria-modal": "true",
    "aria-labelledby": titleId,
    "aria-describedby": descriptionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    "data-test-subj": "dashboardCreateConfirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: titleId,
    component: "h2",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, _dashboard_listing_strings.createConfirmStrings.getCreateTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: descriptionId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 17
    }
  }, _dashboard_listing_strings.createConfirmStrings.getCreateSubtitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "dashboardCreateConfirmCancel",
    onClick: () => session.close(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, _dashboard_listing_strings.createConfirmStrings.getCancelButtonText()), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    "data-test-subj": "dashboardCreateConfirmStartOver",
    onClick: () => {
      startBlankCallback();
      session.close();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, _dashboard_listing_strings.createConfirmStrings.getStartOverButtonText()), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-test-subj": "dashboardCreateConfirmContinue",
    className: "dashboardCreateConfirmContinueButton",
    onClick: () => {
      continueCallback();
      session.close();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 15
    }
  }, _dashboard_listing_strings.createConfirmStrings.getContinueButtonText()))))), _kibana_services.coreServices), {
    'data-test-subj': 'dashboardCreateConfirmModal'
  });
};
exports.confirmCreateWithUnsaved = confirmCreateWithUnsaved;