"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKbnFullScreenBgCss = exports.kbnFullScreenBgCss = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _bg_top_branded = _interopRequireDefault(require("./images/bg_top_branded.svg"));
var _bg_top_branded_dark = _interopRequireDefault(require("./images/bg_top_branded_dark.svg"));
var _bg_bottom_branded = _interopRequireDefault(require("./images/bg_bottom_branded.svg"));
var _bg_bottom_branded_dark = _interopRequireDefault(require("./images/bg_bottom_branded_dark.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// This file replaces scss core/public/_mixins.scss

const kbnFullScreenBgCss = ({
  euiTheme,
  colorMode
}) => {
  const lightOrDarkTheme = (lightSvg, darkSvg) => {
    return colorMode === _eui.COLOR_MODES_STANDARD.light ? lightSvg : darkSvg;
  };
  const fullScreenGraphicsFadeIn = (0, _react2.keyframes)`
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
`;
  return (0, _react2.css)({
    position: 'fixed',
    top: 0,
    left: 0,
    right: 0,
    bottom: 0,
    zIndex: Number(euiTheme.levels.navigation) + 1000,
    background: 'inherit',
    backgroundColor: euiTheme.colors.backgroundBasePlain,
    overflow: 'auto',
    [_eui.euiCanAnimate]: {
      opacity: 0,
      animation: `${fullScreenGraphicsFadeIn} ${euiTheme.animation.extraSlow} ${euiTheme.animation.resistance} 0s forwards`
    },
    '.kbnBody--hasHeaderBanner &': {
      top: 'var(--kbnHeaderBannerHeight)'
    },
    '&::before, &::after': {
      position: 'fixed',
      zIndex: 1,
      width: '400px',
      height: '400px',
      content: `url(${lightOrDarkTheme(_bg_top_branded.default, _bg_top_branded_dark.default)})`,
      [`@media (max-width: ${euiTheme.breakpoint.l}px)`]: {
        content: 'none'
      }
    },
    '&::before': {
      top: 0,
      left: 0,
      content: `url(${lightOrDarkTheme(_bg_top_branded.default, _bg_top_branded_dark.default)})`
    },
    '&::after': {
      bottom: 0,
      right: 0,
      content: `url(${lightOrDarkTheme(_bg_bottom_branded.default, _bg_bottom_branded_dark.default)})`
    }
  });
};
exports.kbnFullScreenBgCss = kbnFullScreenBgCss;
const useKbnFullScreenBgCss = () => {
  const euiTheme = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => kbnFullScreenBgCss(euiTheme), [euiTheme]);
  return styles;
};
exports.useKbnFullScreenBgCss = useKbnFullScreenBgCss;