"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuntimePluginContractResolver = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class RuntimePluginContractResolver {
  constructor() {
    (0, _defineProperty2.default)(this, "dependencyMap", void 0);
    (0, _defineProperty2.default)(this, "setupContracts", void 0);
    (0, _defineProperty2.default)(this, "startContracts", void 0);
    (0, _defineProperty2.default)(this, "setupRequestQueue", []);
    (0, _defineProperty2.default)(this, "startRequestQueue", []);
    (0, _defineProperty2.default)(this, "onSetup", (pluginName, dependencyNames) => {
      var _this$dependencyMap$g;
      if (!this.dependencyMap) {
        throw new Error('onSetup cannot be called before setDependencyMap');
      }
      const dependencyList = (_this$dependencyMap$g = this.dependencyMap.get(pluginName)) !== null && _this$dependencyMap$g !== void 0 ? _this$dependencyMap$g : new Set();
      const notDependencyPlugins = dependencyNames.filter(name => !dependencyList.has(name));
      if (notDependencyPlugins.length) {
        throw new Error('Dynamic contract resolving requires the dependencies to be declared in the plugin manifest.' + `Undeclared dependencies: ${notDependencyPlugins.join(', ')}`);
      }
      if (this.setupContracts) {
        const response = createContractRequestResponse(dependencyNames, this.setupContracts);
        return Promise.resolve(response);
      } else {
        const setupContractRequest = createPluginContractRequest(dependencyNames);
        this.setupRequestQueue.push(setupContractRequest);
        return setupContractRequest.contractPromise;
      }
    });
    (0, _defineProperty2.default)(this, "onStart", (pluginName, dependencyNames) => {
      var _this$dependencyMap$g2;
      if (!this.dependencyMap) {
        throw new Error('onStart cannot be called before setDependencyMap');
      }
      const dependencyList = (_this$dependencyMap$g2 = this.dependencyMap.get(pluginName)) !== null && _this$dependencyMap$g2 !== void 0 ? _this$dependencyMap$g2 : new Set();
      const notDependencyPlugins = dependencyNames.filter(name => !dependencyList.has(name));
      if (notDependencyPlugins.length) {
        throw new Error('Dynamic contract resolving requires the dependencies to be declared in the plugin manifest.' + `Undeclared dependencies: ${notDependencyPlugins.join(', ')}`);
      }
      if (this.startContracts) {
        const response = createContractRequestResponse(dependencyNames, this.startContracts);
        return Promise.resolve(response);
      } else {
        const startContractRequest = createPluginContractRequest(dependencyNames);
        this.startRequestQueue.push(startContractRequest);
        return startContractRequest.contractPromise;
      }
    });
  }
  setDependencyMap(depMap) {
    this.dependencyMap = new Map(depMap.entries());
  }
  resolveSetupRequests(setupContracts) {
    if (this.setupContracts) {
      throw new Error('resolveSetupRequests can only be called once');
    }
    this.setupContracts = setupContracts;
    for (const setupRequest of this.setupRequestQueue) {
      const response = createContractRequestResponse(setupRequest.pluginNames, setupContracts);
      setupRequest.resolve(response);
    }
  }
  resolveStartRequests(startContracts) {
    if (this.startContracts) {
      throw new Error('resolveStartRequests can only be called once');
    }
    this.startContracts = startContracts;
    for (const startRequest of this.startRequestQueue) {
      const response = createContractRequestResponse(startRequest.pluginNames, startContracts);
      startRequest.resolve(response);
    }
  }
}
exports.RuntimePluginContractResolver = RuntimePluginContractResolver;
const createPluginContractRequest = pluginNames => {
  let resolve;
  const contractPromise = new Promise(_resolve => {
    resolve = _resolve;
  });
  return {
    pluginNames,
    contractPromise,
    resolve
  };
};
const createContractRequestResponse = (pluginNames, contracts) => {
  const response = {};
  for (const pluginName of pluginNames) {
    const pluginResponse = contracts.has(pluginName) ? {
      found: true,
      contract: contracts.get(pluginName)
    } : {
      found: false
    };
    response[pluginName] = pluginResponse;
  }
  return response;
};