"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastsApi = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _lodash = require("lodash");
var _apmRum = require("@elastic/apm-rum");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _error_toast = require("./error_toast");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/notifications/browser-internal/src/toasts/toasts_api.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const normalizeToast = toastOrTitle => {
  if (typeof toastOrTitle === 'string') {
    return {
      title: toastOrTitle
    };
  }
  return (0, _lodash.omitBy)(toastOrTitle, _lodash.isUndefined);
};
const getMountPointText = (mountPoint, prefix) => {
  const div = document.createElement('div');
  const unmount = mountPoint(div);
  try {
    return `${prefix}: ${div.textContent || div.innerText || 'Fallback ' + prefix}`;
  } finally {
    unmount === null || unmount === void 0 ? void 0 : unmount();
  }
};
const getToastTitleOrText = toastOrTitle => {
  const toastInfo = [];
  if (typeof toastOrTitle === 'string') {
    toastInfo.push(toastOrTitle);
  } else {
    // Handle toastOrTitle.title?: string | MountPoint
    if (typeof toastOrTitle.title === 'string') {
      toastInfo.push(`Title: ${toastOrTitle.title}`);
    } else if (toastOrTitle.title instanceof Function) {
      toastInfo.push(getMountPointText(toastOrTitle.title, 'Title'));
    }

    // Handle toastOrTitle.text?: string | MountPoint
    if (typeof toastOrTitle.text === 'string') {
      toastInfo.push(`Text: ${toastOrTitle.text}`);
    } else if (toastOrTitle.text instanceof Function) {
      toastInfo.push(getMountPointText(toastOrTitle.text, 'Text'));
    }
  }
  return !!toastInfo.length ? toastInfo.join(', ') : 'No title or text is provided.';
};
const getApmLabels = errorType => {
  return {
    error_type: errorType
  };
};
/**
 * Methods for adding and removing global toast messages.
 * @public
 */
class ToastsApi {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "toasts$", new Rx.BehaviorSubject([]));
    (0, _defineProperty2.default)(this, "idCounter", 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "startDeps", void 0);
    this.uiSettings = deps.uiSettings;
  }

  /** @internal */
  start(startDeps) {
    this.startDeps = startDeps;
  }

  /** Observable of the toast messages queued to be shown to the user. */
  get$() {
    return this.toasts$.asObservable();
  }

  /**
   * Adds a new toast to current array of toast.
   *
   * @param toastOrTitle - a {@link ToastInput}
   * @returns a {@link Toast}
   */
  add(toastOrTitle) {
    const toast = {
      id: String(this.idCounter++),
      toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:info'),
      ...normalizeToast(toastOrTitle)
    };
    this.toasts$.next([...this.toasts$.getValue(), toast]);
    return toast;
  }

  /**
   * Removes a toast from the current array of toasts if present.
   * @param toastOrId - a {@link Toast} returned by {@link ToastsApi.add} or its id
   */
  remove(toastOrId) {
    const toRemove = typeof toastOrId === 'string' ? toastOrId : toastOrId.id;
    const list = this.toasts$.getValue();
    const listWithoutToast = list.filter(t => t.id !== toRemove);
    if (listWithoutToast.length !== list.length) {
      this.toasts$.next(listWithoutToast);
    }
  }

  /**
   * Adds a new toast pre-configured with the info color and info icon.
   *
   * @param toastOrTitle - a {@link ToastInput}
   * @param options - a {@link ToastOptions}
   * @returns a {@link Toast}
   */
  addInfo(toastOrTitle, options) {
    return this.add({
      color: 'primary',
      iconType: 'info',
      ...normalizeToast(toastOrTitle),
      ...options
    });
  }

  /**
   * Adds a new toast pre-configured with the success color and check icon.
   *
   * @param toastOrTitle - a {@link ToastInput}
   * @param options - a {@link ToastOptions}
   * @returns a {@link Toast}
   */
  addSuccess(toastOrTitle, options) {
    return this.add({
      color: 'success',
      iconType: 'check',
      ...normalizeToast(toastOrTitle),
      ...options
    });
  }

  /**
   * Adds a new toast pre-configured with the warning color and help icon.
   *
   * @param toastOrTitle - a {@link ToastInput}
   * @param options - a {@link ToastOptions}
   * @returns a {@link Toast}
   */
  addWarning(toastOrTitle, options) {
    return this.add({
      color: 'warning',
      iconType: 'help',
      toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:warning'),
      ...normalizeToast(toastOrTitle),
      ...options
    });
  }

  /**
   * Adds a new toast pre-configured with the danger color and alert icon.
   *
   * @param toastOrTitle - a {@link ToastInput}
   * @param options - a {@link ToastOptions}
   * @returns a {@link Toast}
   */
  addDanger(toastOrTitle, options) {
    const toastTitle = getToastTitleOrText(toastOrTitle);
    _apmRum.apm.captureError(toastTitle, {
      labels: getApmLabels('ToastDanger')
    });
    return this.add({
      color: 'danger',
      iconType: 'error',
      toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:warning'),
      ...normalizeToast(toastOrTitle),
      ...options
    });
  }

  /**
   * Adds a new toast that displays an exception message with a button to open the full stacktrace in a modal.
   *
   * @param error - an `Error` instance.
   * @param options - {@link ErrorToastOptions}
   * @returns a {@link Toast}
   */
  addError(error, options) {
    const optionsLabels = {
      title: options.title,
      ...(options.toastMessage && {
        toast_message: options.toastMessage
      })
    };
    _apmRum.apm.captureError(error, {
      labels: {
        ...getApmLabels('ToastError'),
        ...optionsLabels
      }
    });
    const message = options.toastMessage || error.message;
    return this.add({
      color: 'danger',
      iconType: 'error',
      toastLifeTimeMs: this.uiSettings.get('notifications:lifetime:error'),
      text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_error_toast.ErrorToast, {
        openModal: this.openModal.bind(this),
        error: error,
        title: options.title,
        toastMessage: message,
        rendering: this.startDeps.rendering,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 9
        }
      })),
      ...options
    });
  }
  openModal(...args) {
    var _this$startDeps;
    const {
      overlays
    } = (_this$startDeps = this.startDeps) !== null && _this$startDeps !== void 0 ? _this$startDeps : {};
    if (!overlays) {
      // This case should never happen because no rendering should be occurring
      // before the ToastService is started.
      throw new Error(`Modal opened before ToastService was started.`);
    }
    return overlays.openModal(...args);
  }
}
exports.ToastsApi = ToastsApi;