"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderLogo = HeaderLogo;
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _url = _interopRequireDefault(require("url"));
var _eui = require("@elastic/eui");
var _elastic_mark = require("./elastic_mark");
var _loading_indicator = require("../loading_indicator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header_logo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function findClosestAnchor(element) {
  let current = element;
  while (current) {
    if (current.tagName === 'A') {
      return current;
    }
    if (!current.parentElement || current.parentElement === document.body) {
      return undefined;
    }
    current = current.parentElement;
  }
}
function onClick(event, forceNavigation, navLinks, navigateToApp) {
  const anchor = findClosestAnchor(event.nativeEvent.target);
  if (!anchor) {
    return;
  }
  if (event.isDefaultPrevented() || event.altKey || event.metaKey || event.ctrlKey) {
    return;
  }
  if (forceNavigation) {
    const toParsed = _url.default.parse(anchor.href);
    const fromParsed = _url.default.parse(document.location.href);
    const sameProto = toParsed.protocol === fromParsed.protocol;
    const sameHost = toParsed.host === fromParsed.host;
    const samePath = toParsed.path === fromParsed.path;
    if (sameProto && sameHost && samePath) {
      if (toParsed.hash) {
        document.location.reload();
      }

      // event.preventDefault() keeps the browser from seeing the new url as an update
      // and even setting window.location does not mimic that behavior, so instead
      // we use stopPropagation() to prevent angular from seeing the click and
      // starting a digest cycle/attempting to handle it in the router.
      event.stopPropagation();
    }
  } else {
    navigateToApp('home');
    event.preventDefault();
  }
}
function HeaderLogo({
  href,
  navigateToApp,
  loadingCount$,
  ...observables
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const forceNavigation = (0, _useObservable.default)(observables.forceNavigation$, false);
  const navLinks = (0, _useObservable.default)(observables.navLinks$, []);
  const customBranding = (0, _useObservable.default)(observables.customBranding$, {});
  const {
    customizedLogo,
    logo
  } = customBranding;
  const styles = {
    logoCss: (0, _react.css)({
      display: 'flex',
      alignItems: 'center',
      height: euiTheme.size.xxl,
      paddingInline: euiTheme.size.s
    }),
    logoMarkCss: (0, _react.css)({
      marginLeft: euiTheme.size.s,
      fill: euiTheme.colors.ghost
    })
  };
  return /*#__PURE__*/_react2.default.createElement("a", {
    onClick: e => onClick(e, forceNavigation, navLinks, navigateToApp),
    css: styles.logoCss,
    href: href,
    "data-test-subj": "logo",
    "aria-label": _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.goHomePageIconAriaLabel', {
      defaultMessage: 'Elastic home'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_loading_indicator.LoadingIndicator, {
    loadingCount$: loadingCount$,
    customLogo: logo,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }), customizedLogo ? /*#__PURE__*/_react2.default.createElement("img", {
    src: customizedLogo,
    "data-test-subj": "logoMark",
    css: styles.logoMarkCss,
    style: {
      maxWidth: '200px',
      maxHeight: '84px'
    },
    alt: "custom mark",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react2.default.createElement(_elastic_mark.ElasticMark, {
    "data-test-subj": "logoMark",
    css: styles.logoMarkCss,
    "aria-hidden": true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  }));
}