"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndexIndexMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _index_name_logic = require("./index_name_logic");
var _index_view_logic = require("./index_view_logic");
var _access_control_index_selector = require("./access_control_index_selector/access_control_index_selector");
var _mappings_logic = require("../../api/mappings/mappings_logic");
var _strip_search_prefix = require("../../utils/strip_search_prefix");
var _app_context = require("../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/index_mappings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchIndexIndexMappings = () => {
  var _error$body;
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    hasDocumentLevelSecurityFeature,
    isHiddenIndex
  } = (0, _kea.useValues)((0, _index_view_logic.IndexViewLogic)({
    http
  }));
  const {
    indexMappingComponent
  } = (0, _app_context.useAppContext)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const IndexMappingComponent = (0, _react.useMemo)(() => indexMappingComponent, []);
  const [selectedIndexType, setSelectedIndexType] = (0, _react.useState)('content-index');
  const indexToShow = selectedIndexType === 'content-index' ? indexName : (0, _strip_search_prefix.stripSearchPrefix)(indexName, _searchConnectors.CONNECTORS_ACCESS_CONTROL_INDEX_PREFIX);
  const {
    makeRequest: makeMappingRequest
  } = (0, _kea.useActions)((0, _mappings_logic.mappingsWithPropsApiLogic)(indexToShow));
  const {
    error
  } = (0, _kea.useValues)((0, _mappings_logic.mappingsWithPropsApiLogic)(indexToShow));
  const shouldShowAccessControlSwitch = hasDocumentLevelSecurityFeature;
  const isAccessControlIndexNotFound = shouldShowAccessControlSwitch && (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 404;
  (0, _react.useEffect)(() => {
    makeMappingRequest({
      indexName: indexToShow,
      http
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [indexToShow, indexName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, shouldShowAccessControlSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
                  width: 100%;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_access_control_index_selector.AccessControlIndexSelector, {
    fullWidth: true,
    onChange: setSelectedIndexType,
    valueOfSelected: selectedIndexType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, isAccessControlIndexNotFound ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    size: "m",
    title: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.mappings.noIndex.title', {
      defaultMessage: 'Access Control Index not found'
    }),
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.mappings.noIndex', {
    defaultMessage: "An Access Control Index won't be created until you enable document-level security and run your first access control sync."
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, IndexMappingComponent ? /*#__PURE__*/_react.default.createElement(IndexMappingComponent, {
    index: {
      aliases: [],
      hidden: isHiddenIndex,
      isFrozen: false,
      name: indexToShow
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "danger",
    iconType: "warn",
    title: _i18n.i18n.translate('xpack.contentConnectors.content.searchIndex.mappings.noMappingsComponent', {
      defaultMessage: 'Mappings component not found'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 21
    }
  })))))));
};
exports.SearchIndexIndexMappings = SearchIndexIndexMappings;