"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.History = History;
var _react = _interopRequireWildcard(require("react"));
var _reactWindow = require("react-window");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _main = require("../main");
var _history_empty = require("./history_empty");
var _contexts = require("../../contexts");
var _editor_context = require("../../contexts/editor_context");
var _history_viewer_monaco = require("./history_viewer_monaco");
var _lib = require("../../lib");
var _types = require("../../../types");
var _styles = require("../styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/history/history.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CHILD_ELEMENT_PREFIX = 'historyReq';
const staticStyles = {
  fullHeight: (0, _react2.css)`
    height: 100%;
  `,
  // Sticky positioned element
  stickyTopElement: (0, _react2.css)`
    top: 0;
  `
};
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    ...staticStyles,
    resizerButton: (0, _styles.useResizerButtonStyles)(),
    consoleEditorPanel: _styles.consoleEditorPanelStyles,
    // Panel with padding and full height
    paddedFullHeightPanel: (0, _react2.css)`
      height: 100%;
      padding-right: ${euiTheme.size.s};
    `,
    // Content area with top padding
    paddedTopContainer: (0, _react2.css)`
      padding-top: ${euiTheme.size.l};
    `
  };
};
const CheckeableCardLabel = ({
  historyItem
}) => {
  const date = (0, _moment.default)(historyItem.time);
  let formattedDate = date.format('MMM D');
  if (date.diff((0, _moment.default)(), 'days') > -7) {
    formattedDate = date.fromNow();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, historyItem.method, " ", historyItem.endpoint))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, formattedDate)));
};
function History() {
  const styles = useStyles();
  const {
    services: {
      history,
      routeHistory
    }
  } = (0, _contexts.useServicesContext)();
  const dispatch = (0, _editor_context.useEditorActionContext)();
  const {
    settings: readOnlySettings
  } = (0, _editor_context.useEditorReadContext)();
  const [requests, setPastRequests] = (0, _react.useState)(history.getHistory());
  const clearHistory = (0, _react.useCallback)(() => {
    history.clearHistory();
    setPastRequests(history.getHistory());
  }, [history]);
  const [viewingReq, setViewingReq] = (0, _react.useState)(null);
  const isVerticalLayout = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);
  const initialize = (0, _react.useCallback)(() => {
    const nextSelectedIndex = 0;
    setViewingReq(requests[nextSelectedIndex]);
  }, [requests]);
  const clear = () => {
    clearHistory();
    initialize();
  };
  const restoreRequestFromHistory = (0, _react.useCallback)(restoreMethod => {
    routeHistory === null || routeHistory === void 0 ? void 0 : routeHistory.push(`/console/${_main.SHELL_TAB_ID}`);
    const formattedRequest = (0, _lib.getFormattedRequest)(viewingReq);
    dispatch({
      type: 'setRequestToRestore',
      payload: {
        request: formattedRequest,
        restoreMethod
      }
    });
  }, [viewingReq, dispatch, routeHistory]);
  (0, _react.useEffect)(() => {
    initialize();
  }, [initialize]);
  const Row = (0, _react.useCallback)(({
    data,
    index,
    style
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormFieldset, {
    key: index,
    "data-test-subj": "historyItemFieldset",
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: `${CHILD_ELEMENT_PREFIX}${index}`,
    label: /*#__PURE__*/_react.default.createElement(CheckeableCardLabel, {
      historyItem: data[index],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 18
      }
    }),
    "data-test-subj": `historyItem-${index}`,
    checkableType: "radio",
    checked: viewingReq === data[index],
    onChange: () => {
      setViewingReq(data[index]);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  })), [viewingReq, setViewingReq]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "none",
    hasShadow: false,
    borderRadius: "none",
    css: styles.fullHeight,
    "data-test-subj": "consoleHistoryPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    css: styles.fullHeight,
    direction: isVerticalLayout ? 'vertical' : 'horizontal',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 50,
    minSize: "30%",
    tabIndex: 0,
    borderRadius: "none",
    hasShadow: false,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    color: "subdued",
    css: styles.paddedFullHeightPanel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
    // column layout with full height
    ,
    css: styles.fullHeight,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.historyPage.pageTitle",
    defaultMessage: "History",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.historyPage.pageDescription",
    defaultMessage: "Revisit and reuse your past queries",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 27
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: styles.fullHeight,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 21
    }
  }, requests.length === 0 && /*#__PURE__*/_react.default.createElement(_history_empty.HistoryEmptyPrompt, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 49
    }
  }), requests.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiAutoSizer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 25
    }
  }, ({
    height,
    width
  }) => /*#__PURE__*/_react.default.createElement(_reactWindow.FixedSizeList, {
    height: height,
    itemCount: requests.length,
    itemSize: 62,
    itemData: requests,
    width: width,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 29
    }
  }, Row))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    color: "subdued",
    paddingSize: "s",
    css: styles.paddedTopContainer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "primary",
    "data-test-subj": "consoleClearHistoryButton",
    onClick: clear,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.historyPage.clearHistoryButtonLabel",
    defaultMessage: "Clear all history",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 23
    }
  })))))), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    css: styles.resizerButton,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: 50,
    minSize: "15%",
    tabIndex: 0,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    color: "subdued",
    css: styles.fullHeight,
    borderRadius: "none",
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none",
    css: [styles.consoleEditorPanel, styles.stickyTopElement],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_history_viewer_monaco.HistoryViewer, {
    settings: readOnlySettings,
    req: viewingReq,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    grow: false,
    css: styles.consoleEditorPanel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "consoleHistoryAddAndRunButton",
    color: "primary",
    iconType: "play",
    disabled: !viewingReq,
    onClick: () => restoreRequestFromHistory(_types.RestoreMethod.RESTORE_AND_EXECUTE),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('console.historyPage.addAndRunButtonLabel', {
    defaultMessage: 'Add and run'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "consoleHistoryApplyButton",
    fill: true,
    color: "primary",
    iconType: "plusInCircle",
    disabled: !viewingReq,
    onClick: () => restoreRequestFromHistory(_types.RestoreMethod.RESTORE),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 23
    }
  }, _i18n.i18n.translate('console.historyPage.applyHistoryButtonLabel', {
    defaultMessage: 'Add'
  }))))))))));
}