"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStandaloneParsedRequestsProvider = exports.createStandaloneParsedRequestsProvider = exports.createStandaloneConsoleParser = exports.StandaloneConsoleParsedRequestsProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _parser = require("@kbn/monaco/src/languages/console/parser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createStandaloneConsoleParser = () => {
  const originalParser = (0, _parser.createParser)();
  return text => {
    if (!text || typeof text !== 'string') {
      return {
        requests: [],
        errors: []
      };
    }
    try {
      const result = originalParser(text, undefined);
      return {
        requests: result.requests || [],
        errors: result.errors || []
      };
    } catch (error) {
      return {
        requests: [],
        errors: [{
          text: `Parse error: ${error}`,
          offset: 0
        }]
      };
    }
  };
};

// Interface that matches ConsoleParsedRequestsProvider from @kbn/monaco
exports.createStandaloneConsoleParser = createStandaloneConsoleParser;
// Standalone provider that implements the same interface as ConsoleParsedRequestsProvider
class StandaloneConsoleParsedRequestsProvider {
  constructor(model) {
    (0, _defineProperty2.default)(this, "parser", void 0);
    this.model = model;
    this.parser = createStandaloneConsoleParser();
  }
  async getRequests() {
    if (!this.model || this.model.isDisposed()) {
      return [];
    }
    try {
      const text = this.model.getValue();
      const result = this.parser(text);
      return result.requests || [];
    } catch (error) {
      return [];
    }
  }
  async getErrors() {
    if (!this.model || this.model.isDisposed()) {
      return [];
    }
    try {
      const text = this.model.getValue();
      const result = this.parser(text);
      return result.errors || [];
    } catch (error) {
      return [];
    }
  }
}

// Factory function to replace getParsedRequestsProvider
exports.StandaloneConsoleParsedRequestsProvider = StandaloneConsoleParsedRequestsProvider;
const getStandaloneParsedRequestsProvider = model => {
  return new StandaloneConsoleParsedRequestsProvider(model);
};

// Factory function that creates the adapter for use in MonacoEditorActionsProvider
exports.getStandaloneParsedRequestsProvider = getStandaloneParsedRequestsProvider;
const createStandaloneParsedRequestsProvider = model => {
  return new StandaloneConsoleParsedRequestsProvider(model);
};
exports.createStandaloneParsedRequestsProvider = createStandaloneParsedRequestsProvider;