"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TinesWebhooksActionResponseSchema = exports.TinesWebhooksActionParamsSchema = exports.TinesWebhookObjectSchema = exports.TinesWebhookActionConfigSchema = exports.TinesStoryObjectSchema = exports.TinesStoriesActionResponseSchema = exports.TinesStoriesActionParamsSchema = exports.TinesSecretsSchema = exports.TinesRunActionResponseSchema = exports.TinesRunActionParamsSchema = exports.TinesConfigSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Connector schema
const TinesConfigSchema = exports.TinesConfigSchema = _zod.z.object({
  url: _zod.z.string()
}).strict();
const TinesSecretsSchema = exports.TinesSecretsSchema = _zod.z.object({
  email: _zod.z.string(),
  token: _zod.z.string()
}).strict();

// Stories action schema
const TinesStoriesActionParamsSchema = exports.TinesStoriesActionParamsSchema = null;
const TinesStoryObjectSchema = exports.TinesStoryObjectSchema = _zod.z.object({
  id: _zod.z.coerce.number(),
  name: _zod.z.string(),
  published: _zod.z.boolean()
}).strict();
const TinesStoriesActionResponseSchema = exports.TinesStoriesActionResponseSchema = _zod.z.object({
  stories: _zod.z.array(TinesStoryObjectSchema),
  incompleteResponse: _zod.z.boolean()
}).strict();

// Webhooks action schema
const TinesWebhooksActionParamsSchema = exports.TinesWebhooksActionParamsSchema = _zod.z.object({
  storyId: _zod.z.coerce.number()
}).strict();
const TinesWebhookObjectSchema = exports.TinesWebhookObjectSchema = _zod.z.object({
  id: _zod.z.coerce.number(),
  name: _zod.z.string(),
  storyId: _zod.z.coerce.number()
});

// Webhooks action configuration schema
const TinesWebhookActionConfigSchema = exports.TinesWebhookActionConfigSchema = _zod.z.object({
  path: _zod.z.string(),
  secret: _zod.z.string()
}).strict();
const TinesWebhooksActionResponseSchema = exports.TinesWebhooksActionResponseSchema = _zod.z.object({
  webhooks: _zod.z.array(TinesWebhookObjectSchema),
  incompleteResponse: _zod.z.boolean()
}).strict();

// Run action schema
const TinesRunActionParamsSchema = exports.TinesRunActionParamsSchema = _zod.z.object({
  webhook: TinesWebhookObjectSchema.optional(),
  webhookUrl: _zod.z.string().optional(),
  body: _zod.z.string()
}).strict();
const TinesRunActionResponseSchema = exports.TinesRunActionResponseSchema = _zod.z.object({});