"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityDescriptionSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _findings_flyout = require("../../configurations/findings_flyout/findings_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_description_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EMPTY_VALUE = 'No description available';
const MAX_LINES = 3;
const VulnerabilityDescriptionSection = ({
  description
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isExpanded, setIsExpanded] = (0, _react.useState)(false);
  const [isOverflowing, setIsOverflowing] = (0, _react.useState)(false);
  const contentRef = (0, _react.useRef)(null);
  const containerRef = (0, _react.useRef)(null);
  const content = description || EMPTY_VALUE;
  const checkOverflow = () => {
    const el = contentRef.current;
    if (el) {
      const style = getComputedStyle(el);
      const lineHeightRaw = style.lineHeight;
      const lineHeight = lineHeightRaw === 'normal' ? 16 : parseFloat(lineHeightRaw);
      const maxHeight = lineHeight * MAX_LINES;
      setIsOverflowing(el.scrollHeight > maxHeight + 1);
    }
  };
  (0, _react.useEffect)(() => {
    // Wait for layout to stabilize before measuring
    requestAnimationFrame(checkOverflow);
  }, [content, isExpanded]);
  (0, _react.useEffect)(() => {
    if (!containerRef.current) return;
    const resizeObserver = new ResizeObserver(() => {
      if (!isExpanded) {
        checkOverflow();
      }
    });
    resizeObserver.observe(containerRef.current);
    return () => resizeObserver.disconnect();
  }, [isExpanded]);
  const clampedStyle = {
    display: '-webkit-box',
    WebkitLineClamp: MAX_LINES,
    WebkitBoxOrient: 'vertical',
    overflow: 'hidden',
    transition: 'all 0.3s ease'
  };
  const expandedStyle = {
    display: 'block',
    transition: 'all 0.3s ease'
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: contentRef,
    style: isExpanded ? expandedStyle : clampedStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_findings_flyout.CspFlyoutMarkdown, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, content)), isExpanded && isOverflowing && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginTop: euiTheme.size.xs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    flush: "left",
    onClick: () => setIsExpanded(false),
    "aria-label": "Show less description",
    style: {
      height: 'auto',
      minHeight: 'auto',
      fontSize: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityDescriptionSection.showLess",
    defaultMessage: "Show less",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }))), isOverflowing && !isExpanded && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginTop: euiTheme.size.xs
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    onClick: () => setIsExpanded(true),
    flush: "left",
    "aria-label": "Show more description",
    style: {
      height: 'auto',
      minHeight: 'auto',
      fontSize: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityDescriptionSection.showMore",
    defaultMessage: "Show more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }))));
};
exports.VulnerabilityDescriptionSection = VulnerabilityDescriptionSection;