"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BenchmarkDetailsBox = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _use_navigate_findings = require("@kbn/cloud-security-posture/src/hooks/use_navigate_findings");
var _constants = require("../../../common/constants");
var _benchmarks_section = require("./benchmarks_section");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _cis_logo = _interopRequireDefault(require("../../../assets/icons/cis_logo.svg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/compliance_dashboard/dashboard_sections/benchmark_details_box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BenchmarkDetailsBox = ({
  benchmark,
  activeNamespace
}) => {
  const navToFindings = (0, _use_navigate_findings.useNavigateFindings)();
  const handleClickCloudProvider = () => {
    navToFindings((0, _benchmarks_section.getBenchmarkIdQuery)(benchmark, activeNamespace), [_constants.FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_ID]);
  };
  const handleClickCluster = () => {
    navToFindings((0, _benchmarks_section.getBenchmarkIdQuery)(benchmark, activeNamespace), [_constants.FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_ID]);
  };
  const getBenchmarkInfo = (benchmarkId, cloudAssetCount) => {
    const benchmarks = {
      cis_gcp: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisGcpBenchmarkName', {
          defaultMessage: 'CIS GCP'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisGcpBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Project} other {# Projects}}',
          values: {
            count: cloudAssetCount
          }
        }),
        handleClick: handleClickCloudProvider
      },
      cis_aws: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAwsBenchmarkName', {
          defaultMessage: 'CIS AWS'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAwsBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Account} other {# Accounts}}',
          values: {
            count: cloudAssetCount
          }
        }),
        handleClick: handleClickCloudProvider
      },
      cis_azure: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAzureBenchmarkName', {
          defaultMessage: 'CIS Azure'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisAzureBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Subscription} other {# Subscriptions}}',
          values: {
            count: cloudAssetCount
          }
        }),
        handleClick: handleClickCloudProvider
      },
      cis_k8s: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisK8sBenchmarkName', {
          defaultMessage: 'CIS Kubernetes'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisK8sBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Cluster} other {# Clusters}}',
          values: {
            count: cloudAssetCount
          }
        }),
        handleClick: handleClickCluster
      },
      cis_eks: {
        name: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisEksBenchmarkName', {
          defaultMessage: 'CIS EKS'
        }),
        assetType: _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisEksBenchmarkAssetType', {
          defaultMessage: '{count, plural, one {# Cluster} other {# Clusters}}',
          values: {
            count: cloudAssetCount
          }
        }),
        handleClick: handleClickCluster
      }
    };
    return benchmarks[benchmarkId];
  };
  const cisTooltip = _i18n.i18n.translate('xpack.csp.dashboard.benchmarkSection.benchmarkName.cisBenchmarkTooltip', {
    defaultMessage: 'Center of Internet Security'
  });
  const benchmarkInfo = getBenchmarkInfo(benchmark.meta.benchmarkId, benchmark.meta.assetCount);
  const benchmarkId = benchmark.meta.benchmarkId;
  const benchmarkVersion = benchmark.meta.benchmarkVersion;
  const benchmarkName = benchmark.meta.benchmarkName;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dashboard.benchmarkSection.benchmarkTitleTooltip.benchmarkPrefixTitle",
      defaultMessage: "Show all findings for ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.dashboard.benchmarkSection.benchmarkTitleTooltip.benchmarkTitle",
      defaultMessage: "{benchmark}",
      values: {
        benchmark: benchmarkName
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 17
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: benchmarkInfo.handleClick,
    color: "text",
    "data-test-subj": "benchmark-section-bench-name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: {
      fontSize: 20
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, benchmarkInfo.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "benchmark-asset-type",
    onClick: benchmarkInfo.handleClick,
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, benchmarkInfo.assetType))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      justifyContent: 'flex-end'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
    type: benchmarkId,
    name: `${benchmarkName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: cisTooltip,
    type: _cis_logo.default,
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, benchmarkVersion))));
};
exports.BenchmarkDetailsBox = BenchmarkDetailsBox;