"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VULNERABILITIES_SEVERITY = exports.STATUS_ROUTE_PATH = exports.STATUS_API_CURRENT_VERSION = exports.SINGLE_ACCOUNT = exports.SECURITY_DEFAULT_DATA_VIEW_ID = exports.ORGANIZATION_ACCOUNT = exports.MISCONFIGURATION_STATUS = exports.MAX_FINDINGS_TO_LOAD = exports.LATEST_VULNERABILITIES_RETENTION_POLICY = exports.LATEST_FINDINGS_RETENTION_POLICY = exports.KSPM_POLICY_TEMPLATE = exports.INTERNAL_FEATURE_FLAGS = exports.GENERIC_ENTITY_INDEX_ENRICH_POLICY = exports.GCP_SINGLE_ACCOUNT = exports.GCP_ORGANIZATION_ACCOUNT = exports.FINDINGS_INDEX_PATTERN = exports.DETECTION_RULE_RULES_API_CURRENT_VERSION = exports.DEPRECATED_CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN = exports.CSP_MOMENT_FORMAT = exports.CSP_MISCONFIGURATIONS_DATASET = exports.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = exports.CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = exports.CSPM_POLICY_TEMPLATE = exports.CLOUD_SECURITY_POSTURE_BASE_PATH = exports.CLOUD_SECURITY_PLUGIN_VERSION = exports.CDR_VULNERABILITIES_INDEX_PATTERN = exports.CDR_VULNERABILITIES_DATA_VIEW_NAME = exports.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX_OLD_VERSIONS = exports.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX_LEGACY_VERSIONS = exports.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX = exports.CDR_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_NAME = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX_OLD_VERSIONS = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX_LEGACY_VERSIONS = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX = exports.CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_ALIAS = exports.CDR_EXTENDED_VULN_RETENTION_POLICY = exports.AZURE_SINGLE_ACCOUNT = exports.AZURE_ORGANIZATION_ACCOUNT = exports.AWS_SINGLE_ACCOUNT = exports.AWS_ORGANIZATION_ACCOUNT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ORGANIZATION_ACCOUNT = exports.ORGANIZATION_ACCOUNT = 'organization-account';
const SINGLE_ACCOUNT = exports.SINGLE_ACCOUNT = 'single-account';
const AZURE_SINGLE_ACCOUNT = exports.AZURE_SINGLE_ACCOUNT = SINGLE_ACCOUNT;
const AZURE_ORGANIZATION_ACCOUNT = exports.AZURE_ORGANIZATION_ACCOUNT = ORGANIZATION_ACCOUNT;
const AWS_SINGLE_ACCOUNT = exports.AWS_SINGLE_ACCOUNT = SINGLE_ACCOUNT;
const AWS_ORGANIZATION_ACCOUNT = exports.AWS_ORGANIZATION_ACCOUNT = ORGANIZATION_ACCOUNT;
const GCP_SINGLE_ACCOUNT = exports.GCP_SINGLE_ACCOUNT = SINGLE_ACCOUNT;
const GCP_ORGANIZATION_ACCOUNT = exports.GCP_ORGANIZATION_ACCOUNT = ORGANIZATION_ACCOUNT;
const KSPM_POLICY_TEMPLATE = exports.KSPM_POLICY_TEMPLATE = 'kspm';
const CSPM_POLICY_TEMPLATE = exports.CSPM_POLICY_TEMPLATE = 'cspm';
const CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_ALIAS = exports.CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_ALIAS = 'security_solution-cloud_security_posture.misconfiguration_latest';
const DEPRECATED_CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN = exports.DEPRECATED_CDR_LATEST_NATIVE_MISCONFIGURATIONS_INDEX_PATTERN = 'logs-cloud_security_posture.findings_latest-default';
const CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN = 'security_solution-*.misconfiguration_latest';
const CDR_MISCONFIGURATIONS_INDEX_PATTERN = exports.CDR_MISCONFIGURATIONS_INDEX_PATTERN = CDR_LATEST_THIRD_PARTY_MISCONFIGURATIONS_INDEX_PATTERN;
const CDR_MISCONFIGURATIONS_DATA_VIEW_NAME = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_NAME = 'Latest Cloud Security Misconfigurations';
const LATEST_FINDINGS_RETENTION_POLICY = exports.LATEST_FINDINGS_RETENTION_POLICY = '26h';
const MAX_FINDINGS_TO_LOAD = exports.MAX_FINDINGS_TO_LOAD = 500;
const CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = exports.CSP_GET_BENCHMARK_RULES_STATE_ROUTE_PATH = '/internal/cloud_security_posture/rules/_get_states';
const CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = exports.CSP_GET_BENCHMARK_RULES_STATE_API_CURRENT_VERSION = '1';
const STATUS_ROUTE_PATH = exports.STATUS_ROUTE_PATH = '/internal/cloud_security_posture/status';
const STATUS_API_CURRENT_VERSION = exports.STATUS_API_CURRENT_VERSION = '1';

/** The base path for all cloud security posture pages. */
const CLOUD_SECURITY_POSTURE_BASE_PATH = exports.CLOUD_SECURITY_POSTURE_BASE_PATH = '/cloud_security_posture';

// Array of legacy data view IDs for migration purposes
const CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX_LEGACY_VERSIONS = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX_LEGACY_VERSIONS = ['cloud_security_posture-303eea10-c475-11ec-af18-c5b9b437dbbe',
// legacy version 8.x version (logs-cloud_security_posture.findings_latest-*)
'cloud_security_posture-9129a080-7f48-11ec-8249-431333f83c5f' // legacy version 8.x version (logs-cloud_security_posture.findings-*)
];
// Array of old data view IDs for migration purposes
// Add new deprecated versions here when updating to a new version
const CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX_OLD_VERSIONS = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX_OLD_VERSIONS = ['security_solution_cdr_latest_misconfigurations' // v1
];

// Current data view ID - increment version when making breaking changes
const CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX = exports.CDR_MISCONFIGURATIONS_DATA_VIEW_ID_PREFIX = 'security_solution_cdr_latest_misconfigurations_v2';
const SECURITY_DEFAULT_DATA_VIEW_ID = exports.SECURITY_DEFAULT_DATA_VIEW_ID = 'security-solution-default';
const CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN = 'logs-cloud_security_posture.vulnerabilities_latest-default';
const CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN = exports.CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN = 'security_solution-*.vulnerability_latest';
const CDR_VULNERABILITIES_INDEX_PATTERN = exports.CDR_VULNERABILITIES_INDEX_PATTERN = `${CDR_LATEST_THIRD_PARTY_VULNERABILITIES_INDEX_PATTERN},${CDR_LATEST_NATIVE_VULNERABILITIES_INDEX_PATTERN}`;
const LATEST_VULNERABILITIES_RETENTION_POLICY = exports.LATEST_VULNERABILITIES_RETENTION_POLICY = '3d';
const CDR_VULNERABILITIES_DATA_VIEW_NAME = exports.CDR_VULNERABILITIES_DATA_VIEW_NAME = 'Latest Cloud Security Vulnerabilities';

// Array of legacy vulnerabilities data view IDs for migration purposes
const CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX_LEGACY_VERSIONS = exports.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX_LEGACY_VERSIONS = ['cloud_security_posture-c406d945-a359-4c04-9a6a-65d66de8706b',
// legacy 8.x version (logs-cloud_security_posture.vulnerabilities-*)
'cloud_security_posture-07a5e6d6-982d-4c7c-a845-5f2be43279c9' // legacy 8.x version (logs-cloud_security_posture.vulnerabilities_latest-*)
];
// Array of old vulnerabilities data view IDs for migration purposes
// Add new deprecated versions here when updating to a new version
const CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX_OLD_VERSIONS = exports.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX_OLD_VERSIONS = ['security_solution_cdr_latest_vulnerabilities' // v1
];

// Current vulnerabilities data view ID - increment version when making breaking changes
const CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX = exports.CDR_VULNERABILITIES_DATA_VIEW_ID_PREFIX = 'security_solution_cdr_latest_vulnerabilities_v2';

// meant as a temp workaround to get good enough posture view for 3rd party integrations, see https://github.com/elastic/security-team/issues/10683 and https://github.com/elastic/security-team/issues/10801
const CDR_EXTENDED_VULN_RETENTION_POLICY = exports.CDR_EXTENDED_VULN_RETENTION_POLICY = '90d';
const CSP_MISCONFIGURATIONS_DATASET = exports.CSP_MISCONFIGURATIONS_DATASET = 'cloud_security_posture.findings';
const VULNERABILITIES_SEVERITY = exports.VULNERABILITIES_SEVERITY = {
  LOW: 'LOW',
  MEDIUM: 'MEDIUM',
  HIGH: 'HIGH',
  CRITICAL: 'CRITICAL',
  UNKNOWN: 'UNKNOWN'
};
const MISCONFIGURATION_STATUS = exports.MISCONFIGURATION_STATUS = {
  PASSED: 'passed',
  FAILED: 'failed',
  UNKNOWN: 'unknown'
};
const CSP_MOMENT_FORMAT = exports.CSP_MOMENT_FORMAT = 'MMMM D, YYYY @ HH:mm:ss.SSS';

// A mapping of in-development features to their status. These features should be hidden from users but can be easily
// activated via a simple code change in a single location.
const INTERNAL_FEATURE_FLAGS = exports.INTERNAL_FEATURE_FLAGS = {
  showManageRulesMock: false,
  showFindingFlyoutEvidence: true
};
const DETECTION_RULE_RULES_API_CURRENT_VERSION = exports.DETECTION_RULE_RULES_API_CURRENT_VERSION = '2023-10-31';
const FINDINGS_INDEX_PATTERN = exports.FINDINGS_INDEX_PATTERN = 'logs-cloud_security_posture.findings-default*';

// space plachoder - to be replaced by the specific kibana space
const GENERIC_ENTITY_INDEX_ENRICH_POLICY = exports.GENERIC_ENTITY_INDEX_ENRICH_POLICY = 'entity_store_field_retention_generic_<space>_v1.0.0';
const CLOUD_SECURITY_PLUGIN_VERSION = exports.CLOUD_SECURITY_PLUGIN_VERSION = '1.9.0';