"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserAttachmentUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _timestamp = require("../timestamp");
var _markdown_form = require("../markdown_form");
var _content_toolbar = require("../content_toolbar");
var _hoverable_username_resolver = require("../../user_profiles/hoverable_username_resolver");
var _hoverable_avatar_resolver = require("../../user_profiles/hoverable_avatar_resolver");
var _user_comment_property_actions = require("../property_actions/user_comment_property_actions");
var _utils = require("../../markdown_editor/utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/comment/user.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getCommentFooterCss = euiTheme => {
  if (!euiTheme) {
    return (0, _react2.css)``;
  }
  return (0, _react2.css)`
    border-top: ${euiTheme.border.thin};
    padding: ${euiTheme.size.s};
  `;
};
const createCommentActionCss = euiTheme => {
  if (!euiTheme) {
    return (0, _react2.css)``;
  }
  return (0, _react2.css)`
    [class*='euiTimelineItemEvent'] {
      max-width: calc(100% - (${euiTheme.size.xl} + ${euiTheme.size.base}));
    }
  `;
};
const hasDraftComment = (applicationId = '', caseId, commentId, comment) => {
  const draftStorageKey = (0, _utils.getMarkdownEditorStorageKey)({
    appId: applicationId,
    caseId,
    commentId
  });
  const sessionValue = sessionStorage.getItem(draftStorageKey);
  return Boolean(sessionValue && sessionValue !== comment);
};
const createUserAttachmentUserActionBuilder = ({
  appId,
  attachment,
  userProfiles,
  outlined,
  isEdit,
  isLoading,
  commentRefs,
  caseId,
  euiTheme,
  handleManageMarkdownEditId,
  handleSaveComment,
  handleManageQuote,
  handleDeleteComment
}) => ({
  build: () => [{
    username: /*#__PURE__*/_react.default.createElement(_hoverable_username_resolver.HoverableUsernameResolver, {
      user: attachment.createdBy,
      userProfiles: userProfiles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }),
    'data-test-subj': `comment-create-action-${attachment.id}`,
    timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
      createdAt: attachment.createdAt,
      updatedAt: attachment.updatedAt,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }),
    className: (0, _classnames.default)('userAction__comment', {
      outlined,
      isEdit,
      draftFooter: !isEdit && !isLoading && hasDraftComment(appId, caseId, attachment.id, attachment.comment)
    }),
    css: createCommentActionCss(euiTheme),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_markdown_form.UserActionMarkdown, {
      key: isEdit ? attachment.id : undefined,
      ref: element => commentRefs.current[attachment.id] = element,
      id: attachment.id,
      content: attachment.comment,
      isEditable: isEdit,
      caseId: caseId,
      onChangeEditable: handleManageMarkdownEditId,
      onSaveContent: handleSaveComment.bind(null, {
        id: attachment.id,
        version: attachment.version
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }), !isEdit && !isLoading && hasDraftComment(appId, caseId, attachment.id, attachment.comment) ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: getCommentFooterCss(euiTheme),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      "data-test-subj": "user-action-comment-unsaved-draft",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 15
      }
    }, i18n.UNSAVED_DRAFT_COMMENT)) : ''),
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_hoverable_avatar_resolver.HoverableAvatarResolver, {
      user: attachment.createdBy,
      userProfiles: userProfiles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }),
    actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
      id: attachment.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_user_comment_property_actions.UserCommentPropertyActions, {
      isLoading: isLoading,
      commentContent: attachment.comment,
      onEdit: () => handleManageMarkdownEditId(attachment.id),
      onDelete: () => handleDeleteComment(attachment.id, i18n.DELETE_COMMENT_SUCCESS_TITLE),
      onQuote: () => handleManageQuote(attachment.comment),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }))
  }]
});
exports.createUserAttachmentUserActionBuilder = createUserAttachmentUserActionBuilder;