"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFocusButtonTrap = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFocusButtonTrap = focusButtonRef => {
  const focusTrapProps = (0, _react.useMemo)(() => ({
    returnFocus() {
      if (focusButtonRef && 'current' in focusButtonRef && focusButtonRef.current) {
        focusButtonRef.current.focus();
        return false;
      }
      return true;
    }
  }), [focusButtonRef]);
  return focusTrapProps;
};
exports.useFocusButtonTrap = useFocusButtonTrap;