"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.embeddableRendererFactory = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _public = require("@kbn/embeddable-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lib = require("../../../common/lib");
var _i18n = require("../../../i18n");
var _embeddable_input_to_expression = require("./embeddable_input_to_expression");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/embeddable/embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  embeddable: strings
} = _i18n.RendererStrings;
const children = {};
const renderReactEmbeddable = ({
  type,
  uuid,
  input,
  container,
  handlers,
  core
}) => {
  // wrap in functional component to allow usage of hooks
  const RendererWrapper = () => {
    const subscriptionRef = (0, _react.useRef)(undefined);

    // Clean up subscriptionRef onUnmount
    (0, _react.useEffect)(() => {
      return () => {
        var _subscriptionRef$curr;
        (_subscriptionRef$curr = subscriptionRef.current) === null || _subscriptionRef$curr === void 0 ? void 0 : _subscriptionRef$curr.unsubscribe();
      };
    }, []);

    // set intial panel state onMount
    (0, _react.useMemo)(() => {
      container.setSerializedStateForChild(uuid, {
        rawState: (0, _lodash.omit)(input, ['disableTriggers', 'filters'])
      });
    }, []);
    const searchApi = (0, _react.useMemo)(() => {
      return {
        filters$: new _rxjs.BehaviorSubject(input.filters),
        query$: new _rxjs.BehaviorSubject(undefined),
        timeRange$: new _rxjs.BehaviorSubject(undefined)
      };
    }, []);
    return /*#__PURE__*/_react.default.createElement(_public.EmbeddableRenderer, {
      type: type,
      maybeId: uuid,
      getParentApi: () => ({
        ...container,
        ...searchApi
      }),
      key: `${type}_${uuid}`,
      onApiAvailable: api => {
        if ((0, _presentationPublishing.apiPublishesUnsavedChanges)(api) && (0, _presentationPublishing.apiHasSerializableState)(api)) {
          subscriptionRef.current = api.hasUnsavedChanges$.subscribe(hasUnsavedChanges => {
            if (!hasUnsavedChanges) return;
            const newState = api.serializeState();
            // canvas auto-saves so update child state on any change
            container.setSerializedStateForChild(uuid, newState);
            const newExpression = (0, _embeddable_input_to_expression.embeddableInputToExpression)(newState.rawState, type, undefined, true);
            if (newExpression) handlers.onEmbeddableInputChange(newExpression);
          });
        }
        children[uuid] = {
          ...api,
          setFilters: filters => {
            if (!(0, _esQuery.onlyDisabledFiltersChanged)(searchApi.filters$.getValue(), filters, {
              ..._esQuery.COMPARE_ALL_OPTIONS,
              // do not compare $state to avoid refreshing when filter is pinned/unpinned (which does not impact results)
              state: false
            })) {
              searchApi.filters$.next(filters);
            }
          }
        };
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: _lib.CANVAS_EMBEDDABLE_CLASSNAME,
    style: {
      width: '100%',
      height: '100%',
      cursor: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(RendererWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  })));
};
const embeddableRendererFactory = (core, plugins) => {
  return () => ({
    name: 'embeddable',
    displayName: strings.getDisplayName(),
    help: strings.getHelpDescription(),
    reuseDomNode: true,
    render: async (domNode, {
      input,
      embeddableType,
      canvasApi
    }, handlers) => {
      const uuid = handlers.getElementId();
      const api = children[uuid];
      if (!api) {
        _reactDom.default.render(renderReactEmbeddable({
          input,
          handlers,
          uuid,
          type: embeddableType,
          container: canvasApi,
          core
        }), domNode, () => handlers.done());
        handlers.onDestroy(() => {
          delete children[uuid];
          handlers.onEmbeddableDestroyed();
          return _reactDom.default.unmountComponentAtNode(domNode);
        });
      } else {
        api.setFilters(input.filters);
      }
    }
  });
};
exports.embeddableRendererFactory = embeddableRendererFactory;