"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAutomaticImportAgent = void 0;
var _prebuilt = require("@langchain/langgraph/prebuilt");
var _sub_agents = require("./sub_agents");
var _tools = require("./tools");
var _prompts = require("./prompts");
var _state = require("./state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_RECURSION_LIMIT = 100;

/**
 * Creates an automatic import agent with the given parameters.
 * Subagents can be provided to customize behavior, including passing
 * pre-configured agents with samples (without storing samples in context).
 *
 * @param params - The parameters for the automatic import agent
 * @returns The automatic import agent
 */
const createAutomaticImportAgent = params => {
  const {
    model,
    subagents
  } = params;
  const stateSchema = _state.AutomaticImportAgentState;
  const allTools = [];
  const uniqueKeysTool = (0, _tools.fetchUniqueKeysTool)();
  allTools.push(uniqueKeysTool);
  const currentPipelineTool = (0, _tools.fetchCurrentPipelineTool)();
  allTools.push(currentPipelineTool);
  const taskTool = (0, _sub_agents.createTaskTool)({
    subagents,
    model,
    recursionLimit: AGENT_RECURSION_LIMIT
  });
  allTools.push(taskTool);

  // Return createReactAgent with proper configuration
  const baseAgent = (0, _prebuilt.createReactAgent)({
    name: 'automatic_import_agent',
    llm: model,
    tools: allTools,
    // TypeScript workaround to appease the expected type
    stateSchema,
    messageModifier: _prompts.AUTOMATIC_IMPORT_AGENT_PROMPT
  });
  return baseAgent.withConfig({
    recursionLimit: AGENT_RECURSION_LIMIT
  });
};
exports.createAutomaticImportAgent = createAutomaticImportAgent;