"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAgentTools = registerAgentTools;
var _get_downstream_dependencies = require("./get_downstream_dependencies");
var _get_services = require("./get_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function registerAgentTools({
  core,
  plugins,
  logger
}) {
  const apmTools = [(0, _get_downstream_dependencies.createDownstreamDependenciesTool)({
    core,
    plugins,
    logger
  }), (0, _get_services.createGetServicesTool)({
    core,
    plugins,
    logger
  })];
  for (const tool of apmTools) {
    var _plugins$onechat;
    (_plugins$onechat = plugins.onechat) === null || _plugins$onechat === void 0 ? void 0 : _plugins$onechat.tools.register(tool);
  }
}