"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceIcons = ServiceIcons;
exports.getContainerIcon = getContainerIcon;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _customIcons = require("@kbn/custom-icons");
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../hooks/use_fetcher");
var _cloud_details = require("./cloud_details");
var _serverless_details = require("./serverless_details");
var _container_details = require("./container_details");
var _otel_details = require("./otel_details");
var _icon_popover = require("./icon_popover");
var _service_details = require("./service_details");
var _serverless = require("../../../../common/serverless");
var _agent_name = require("../../../../common/agent_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/service_icons/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getServerlessTitle(serverlessType) {
  switch (serverlessType) {
    case _serverless.ServerlessType.AWS_LAMBDA:
      {
        return _i18n.i18n.translate('xpack.apm.serviceIcons.aws_lambda', {
          defaultMessage: 'AWS Lambda'
        });
      }
    case _serverless.ServerlessType.AZURE_FUNCTIONS:
      {
        return _i18n.i18n.translate('xpack.apm.serviceIcons.azure_functions', {
          defaultMessage: 'Azure Functions'
        });
      }
    default:
      {
        return _i18n.i18n.translate('xpack.apm.serviceIcons.serverless', {
          defaultMessage: 'Serverless'
        });
      }
  }
}
function getContainerIcon(container) {
  if (!container) {
    return;
  }
  switch (container) {
    case 'Kubernetes':
      return 'logoKubernetes';
    default:
      return 'logoDocker';
  }
}
function ServiceIcons({
  start,
  end,
  serviceName,
  environment
}) {
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const [selectedIconPopover, setSelectedIconPopover] = (0, _react.useState)();
  const {
    data: icons,
    status: iconsFetchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end) {
      return callApmApi('GET /internal/apm/services/{serviceName}/metadata/icons', {
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end
          }
        }
      });
    }
  }, [serviceName, start, end]);
  const {
    data: details,
    status: detailsFetchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (selectedIconPopover && serviceName && start && end && environment) {
      return callApmApi('GET /internal/apm/services/{serviceName}/metadata/details', {
        isCachable: true,
        params: {
          path: {
            serviceName
          },
          query: {
            start,
            end,
            environment
          }
        }
      });
    }
  }, [selectedIconPopover, serviceName, start, end, environment]);
  const isLoading = !icons && iconsFetchStatus === _use_fetcher.FETCH_STATUS.LOADING;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "loading",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 12
      }
    });
  }
  const popoverItems = [{
    key: 'service',
    icon: {
      type: (0, _customIcons.getAgentIcon)(icons === null || icons === void 0 ? void 0 : icons.agentName, isDarkMode) || 'node'
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.agentName),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.service', {
      defaultMessage: 'Service'
    }),
    component: /*#__PURE__*/_react.default.createElement(_service_details.ServiceDetails, {
      service: details === null || details === void 0 ? void 0 : details.service,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 18
      }
    })
  }, {
    key: 'opentelemetry',
    icon: {
      type: (0, _customIcons.getAgentIcon)('opentelemetry', isDarkMode)
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.agentName) && (0, _agent_name.isOpenTelemetryAgentName)(icons.agentName),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.opentelemetry', {
      defaultMessage: 'OpenTelemetry'
    }),
    component: /*#__PURE__*/_react.default.createElement(_otel_details.OTelDetails, {
      opentelemetry: details === null || details === void 0 ? void 0 : details.opentelemetry,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 18
      }
    })
  }, {
    key: 'container',
    icon: {
      type: getContainerIcon(icons === null || icons === void 0 ? void 0 : icons.containerType)
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.containerType),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.container', {
      defaultMessage: 'Container'
    }),
    component: /*#__PURE__*/_react.default.createElement(_container_details.ContainerDetails, {
      container: details === null || details === void 0 ? void 0 : details.container,
      kubernetes: details === null || details === void 0 ? void 0 : details.kubernetes,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    })
  }, {
    key: 'serverless',
    icon: {
      type: (0, _customIcons.getServerlessIcon)(icons === null || icons === void 0 ? void 0 : icons.serverlessType) || 'node'
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.serverlessType),
    title: getServerlessTitle(icons === null || icons === void 0 ? void 0 : icons.serverlessType),
    component: /*#__PURE__*/_react.default.createElement(_serverless_details.ServerlessDetails, {
      serverless: details === null || details === void 0 ? void 0 : details.serverless,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 18
      }
    })
  }, {
    key: 'cloud',
    icon: {
      type: (0, _customIcons.getCloudProviderIcon)(icons === null || icons === void 0 ? void 0 : icons.cloudProvider)
    },
    isVisible: !!(icons !== null && icons !== void 0 && icons.cloudProvider),
    title: _i18n.i18n.translate('xpack.apm.serviceIcons.cloud', {
      defaultMessage: 'Cloud'
    }),
    component: /*#__PURE__*/_react.default.createElement(_cloud_details.CloudDetails, {
      cloud: details === null || details === void 0 ? void 0 : details.cloud,
      isServerless: !!(details !== null && details !== void 0 && details.serverless),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 18
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  }, popoverItems.map(item => {
    if (item.isVisible) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        "data-test-subj": item.key,
        key: item.key,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_icon_popover.IconPopover, {
        isOpen: selectedIconPopover === item.key,
        icon: item.icon,
        detailsFetchStatus: detailsFetchStatus,
        title: item.title,
        onClick: () => {
          setSelectedIconPopover(prevSelectedIconPopover => item.key === prevSelectedIconPopover ? null : item.key);
        },
        onClose: () => {
          setSelectedIconPopover(null);
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 15
        }
      }, item.component));
    }
  }));
}