"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmDatePicker = ApmDatePicker;
exports.DEFAULT_REFRESH_INTERVAL = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _ = require(".");
var _use_time_range_id = require("../../../context/time_range_id/use_time_range_id");
var _helpers = require("../../../context/url_params_context/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/date_picker/apm_date_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_REFRESH_INTERVAL = exports.DEFAULT_REFRESH_INTERVAL = 60000;
function ApmDatePicker() {
  var _toNumber;
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  if (!('rangeFrom' in query)) {
    throw new Error('range not available in route parameters');
  }
  const {
    rangeFrom,
    rangeTo,
    refreshPaused: refreshPausedFromUrl = 'true',
    refreshInterval: refreshIntervalFromUrl
  } = query;
  const refreshPaused = (0, _helpers.toBoolean)(refreshPausedFromUrl);
  const refreshInterval = (_toNumber = (0, _helpers.toNumber)(refreshIntervalFromUrl)) !== null && _toNumber !== void 0 ? _toNumber : DEFAULT_REFRESH_INTERVAL;
  const {
    incrementTimeRangeId
  } = (0, _use_time_range_id.useTimeRangeId)();
  return /*#__PURE__*/_react.default.createElement(_.DatePicker, {
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    refreshPaused: refreshPaused,
    refreshInterval: refreshInterval,
    onTimeRangeRefresh: () => {
      incrementTimeRangeId();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
}