"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLHeader = MLHeader;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _mlsingle_metric_link = require("../../links/machine_learning_links/mlsingle_metric_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/transaction_charts/ml_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShiftedIconWrapper = _styled.default.span`
  padding-right: 5px;
  position: relative;
  top: -1px;
  display: inline-block;
`;
const ShiftedEuiText = (0, _styled.default)(_eui.EuiText)`
  position: relative;
  top: 5px;
`;
function MLHeader({
  hasValidMlLicense,
  mlJobId
}) {
  const {
    transactionType,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      kuery
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  if (!hasValidMlLicense || !mlJobId) {
    return null;
  }
  const hasKuery = !(0, _lodash.isEmpty)(kuery);
  const icon = hasKuery ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    "aria-label": _i18n.i18n.translate('xpack.apm.mLHeader.euiIconTip.warningLabel', {
      defaultMessage: 'Warning'
    }),
    type: "warning",
    color: "warning",
    content: _i18n.i18n.translate('xpack.apm.metrics.transactionChart.machineLearningTooltip.withKuery', {
      defaultMessage: 'The Machine learning results are hidden when the search bar is used for filtering'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.apm.metrics.transactionChart.machineLearningTooltip', {
      defaultMessage: 'The stream displays the expected bounds of the average latency. A red vertical annotation indicates anomalies with an anomaly score of 75 or above.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ShiftedEuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ShiftedIconWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, icon), /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.metrics.transactionChart.machineLearningLabel', {
    defaultMessage: 'Machine learning:'
  }), ' '), /*#__PURE__*/_react.default.createElement(_mlsingle_metric_link.MLSingleMetricLink, {
    jobId: mlJobId,
    serviceName: serviceName,
    transactionType: transactionType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.metrics.transactionChart.viewJob', {
    defaultMessage: 'View Job'
  }))));
}