"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSoonRoute = void 0;
var _run_soon = require("../../../../../common/routes/rule/apis/run_soon");
var _lib = require("../../../lib");
var _types = require("../../../../types");
var _constants = require("../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const runSoonRoute = (router, licenseState) => {
  router.post({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rule/{id}/_run_soon`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      params: _run_soon.runSoonRequestParamsSchemaV1,
      query: _run_soon.runSoonRequestQuerySchemaV1
    }
  }, router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async function (context, req, res) {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const params = req.params;
    const query = req.query;
    const message = await rulesClient.runSoon({
      id: params.id,
      force: query === null || query === void 0 ? void 0 : query.force
    });
    return message ? res.ok({
      body: message
    }) : res.noContent();
  })));
};
exports.runSoonRoute = runSoonRoute;