"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statusSchema = exports.backfillSchema = exports.backfillScheduleSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _responseOpsRuleParams = require("@kbn/response-ops-rule-params");
var _constants = require("../../../../../common/constants");
var _action_schemas = require("../../../rule/schemas/action_schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusSchema = exports.statusSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.adHocRunStatus.COMPLETE), _configSchema.schema.literal(_constants.adHocRunStatus.PENDING), _configSchema.schema.literal(_constants.adHocRunStatus.RUNNING), _configSchema.schema.literal(_constants.adHocRunStatus.ERROR), _configSchema.schema.literal(_constants.adHocRunStatus.TIMEOUT)]);
const backfillScheduleSchema = exports.backfillScheduleSchema = _configSchema.schema.object({
  runAt: _configSchema.schema.string(),
  status: statusSchema,
  interval: _configSchema.schema.string()
});
const backfillSchema = exports.backfillSchema = _configSchema.schema.object({
  id: _configSchema.schema.string(),
  createdAt: _configSchema.schema.string(),
  duration: _configSchema.schema.string(),
  enabled: _configSchema.schema.boolean(),
  rule: _configSchema.schema.object({
    id: _configSchema.schema.string(),
    name: _configSchema.schema.string(),
    tags: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    actions: _configSchema.schema.arrayOf(_action_schemas.actionSchema),
    alertTypeId: _configSchema.schema.string(),
    params: _responseOpsRuleParams.ruleParamsSchema,
    apiKeyOwner: _configSchema.schema.nullable(_configSchema.schema.string()),
    apiKeyCreatedByUser: _configSchema.schema.maybe(_configSchema.schema.nullable(_configSchema.schema.boolean())),
    consumer: _configSchema.schema.string(),
    enabled: _configSchema.schema.boolean(),
    schedule: _configSchema.schema.object({
      interval: _configSchema.schema.string()
    }),
    createdBy: _configSchema.schema.nullable(_configSchema.schema.string()),
    updatedBy: _configSchema.schema.nullable(_configSchema.schema.string()),
    createdAt: _configSchema.schema.string(),
    updatedAt: _configSchema.schema.string(),
    revision: _configSchema.schema.number()
  }),
  spaceId: _configSchema.schema.string(),
  start: _configSchema.schema.string(),
  status: statusSchema,
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  schedule: _configSchema.schema.arrayOf(backfillScheduleSchema),
  initiator: _configSchema.schema.oneOf([_configSchema.schema.literal(_constants.backfillInitiator.USER), _configSchema.schema.literal(_constants.backfillInitiator.SYSTEM)]),
  initiatorId: _configSchema.schema.maybe(_configSchema.schema.string()),
  warnings: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});