"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectFields = selectFields;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function selectFields(analysis, {
  dropEmpty,
  dropUnmapped,
  limit
}) {
  const filteredFields = analysis.fields.filter(field => {
    if (dropEmpty && field.empty) {
      return false;
    }
    if (dropUnmapped && field.types.length === 0) {
      return false;
    }
    return true;
  });
  const [nonEmptyFields, emptyFields] = (0, _lodash.partition)(filteredFields, field => !field.empty);

  // randomize field selection to get a somewhat more illustrative set of fields when
  // the # of fields exceeds the threshold, instead of alphabetically sorted
  // additionally, prefer non-empty fields over empty fields

  const prioritizedFields = [...(0, _lodash.shuffle)(nonEmptyFields), ...(0, _lodash.shuffle)(emptyFields)];
  const limitedFields = prioritizedFields.slice(0, Math.max(0, limit));
  return limitedFields;
}