"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildGetPlanOptionsFromPlanParams = buildGetPlanOptionsFromPlanParams;
function buildGetPlanOptionsFromPlanParams(params) {
    if (params.rootConstraints.isMultiple) {
        return {
            chained: params.rootConstraints.chained,
            isMultiple: true,
            name: params.rootConstraints.name,
            optional: params.rootConstraints.isOptional ?? false,
            serviceIdentifier: params.rootConstraints.serviceIdentifier,
            tag: params.rootConstraints.tag,
        };
    }
    else {
        return {
            isMultiple: false,
            name: params.rootConstraints.name,
            optional: params.rootConstraints.isOptional ?? false,
            serviceIdentifier: params.rootConstraints.serviceIdentifier,
            tag: params.rootConstraints.tag,
        };
    }
}
//# sourceMappingURL=buildGetPlanOptionsFromPlanParams.js.map