"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withEuiStylesMemoizer = exports.useEuiMemoizedStyles = exports.RenderWithEuiStylesMemoizer = exports.EuiThemeMemoizedStylesProvider = exports.EuiThemeMemoizedStylesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../hooks");
var _hooks2 = require("./hooks");
var _warning = require("./warning");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ // Typically an object of serialized css`` styles, but can have any amount of nesting, so it's not worth it to try and strictly type this
var EuiThemeMemoizedStylesContext = exports.EuiThemeMemoizedStylesContext = /*#__PURE__*/(0, _react.createContext)(new WeakMap());
var EuiThemeMemoizedStylesProvider = exports.EuiThemeMemoizedStylesProvider = function EuiThemeMemoizedStylesProvider(_ref) {
  var children = _ref.children;
  // Note: we *should not* use `useMemo` instead of `useState` here, as useMemo is not guaranteed
  // and its cache can get thrown away by React (https://react.dev/reference/react/useMemo#caveats)
  var _useState = (0, _react.useState)(new WeakMap()),
    _useState2 = _slicedToArray(_useState, 2),
    componentStyles = _useState2[0],
    rerenderStyles = _useState2[1];

  // On theme update, wipe the map, which causes the below hook to recompute all styles
  var _useEuiTheme = (0, _hooks2.useEuiTheme)(),
    euiTheme = _useEuiTheme.euiTheme;
  (0, _hooks.useUpdateEffect)(function () {
    rerenderStyles(new WeakMap());
  }, [euiTheme]);
  return (0, _react2.jsx)(EuiThemeMemoizedStylesContext.Provider, {
    value: componentStyles
  }, children);
};

/**
 * Internal util primarily responsible for getting the memoized styles (if they exist)
 * and if not, generating and setting the styles. DRYed out to facilitate usage
 * between both hook/function components and HOC/class components
 */
var getMemoizedStyles = function getMemoizedStyles(stylesGenerator, stylesMap, euiThemeContext) {
  if (!stylesGenerator.name) {
    (0, _warning.emitEuiProviderWarning)('Styles are memoized per function. Your style functions must be statically defined in order to not create a new map entry every rerender.');
  }
  var existingStyles = stylesMap.get(stylesGenerator);
  if (existingStyles) {
    return existingStyles;
  } else {
    var generatedStyles = stylesGenerator(euiThemeContext);
    stylesMap.set(stylesGenerator, generatedStyles);
    return generatedStyles;
  }
};

/**
 * Hook that memoizes the returned values of components style fns/generators
 * per-theme
 */
var useEuiMemoizedStyles = exports.useEuiMemoizedStyles = function useEuiMemoizedStyles(stylesGenerator) {
  var memoizedStyles = (0, _react.useContext)(EuiThemeMemoizedStylesContext);
  var euiThemeContext = (0, _hooks2.useEuiTheme)();
  var memoizedComponentStyles = (0, _react.useMemo)(function () {
    return getMemoizedStyles(stylesGenerator, memoizedStyles, euiThemeContext);
  }, [stylesGenerator, memoizedStyles, euiThemeContext]);
  return memoizedComponentStyles;
};

/**
 * HOC for class components
 * Syntax is mostly copied from withEuiTheme HOC
 */

var withEuiStylesMemoizer = exports.withEuiStylesMemoizer = function withEuiStylesMemoizer(Component) {
  var componentName = Component.displayName || Component.name || 'ComponentWithStylesMemoizer';
  var Render = function Render(props, ref) {
    var memoizedStyles = (0, _react.useContext)(EuiThemeMemoizedStylesContext);
    var euiThemeContext = (0, _hooks2.useEuiTheme)();
    var stylesMemoizer = (0, _react.useCallback)(function (stylesGenerator) {
      return getMemoizedStyles(stylesGenerator, memoizedStyles, euiThemeContext);
    }, [memoizedStyles, euiThemeContext]);
    return (0, _react2.jsx)(Component, _extends({
      stylesMemoizer: stylesMemoizer,
      ref: ref
    }, props));
  };
  var WithEuiStylesMemoizer = /*#__PURE__*/(0, _react.forwardRef)(Render);
  WithEuiStylesMemoizer.displayName = componentName;
  return WithEuiStylesMemoizer;
};

/**
 * Render prop alternative for complex class components
 * Most useful for scenarios where a HOC may interfere with typing
 */
var RenderWithEuiStylesMemoizer = exports.RenderWithEuiStylesMemoizer = function RenderWithEuiStylesMemoizer(_ref2) {
  var children = _ref2.children;
  var memoizedStyles = (0, _react.useContext)(EuiThemeMemoizedStylesContext);
  var euiThemeContext = (0, _hooks2.useEuiTheme)();
  var stylesMemoizer = (0, _react.useCallback)(function (stylesGenerator) {
    return getMemoizedStyles(stylesGenerator, memoizedStyles, euiThemeContext);
  }, [memoizedStyles, euiThemeContext]);
  return children(stylesMemoizer);
};