"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiDataGridColumnSelectorStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../../global_styling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiDataGridColumnSelectorStyles = exports.euiDataGridColumnSelectorStyles = function euiDataGridColumnSelectorStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var maxStaticHeight = (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
    return x * 25;
  });
  var maxResponsiveHeight = "min(".concat(maxStaticHeight, ", 50vh)");
  return {
    euiDataGridColumnSelector: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiYScrollWithShadows)(euiThemeContext), " ", (0, _global_styling.logicalCSS)('max-height', maxResponsiveHeight), " padding:", euiTheme.size.s, ";;label:euiDataGridColumnSelector;"),
    euiDataGridColumnSelector__item: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.xs, ";&.euiDataGridColumnSelector__item-isDragging{", (0, _euiThemeCommon.euiShadowLarge)(euiThemeContext, {
      borderAllInHighContrastMode: true
    }), " background-color:", euiTheme.colors.emptyShade, ";};label:euiDataGridColumnSelector__item;")
  };
};