"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LIGHT_THEME = void 0;
const base_colors_1 = require("./base_colors");
const borealis_colors_1 = require("./borealis_colors");
const theme_common_1 = require("./theme_common");
const theme_1 = require("../../chart_types/bullet_graph/theme");
const colors_1 = require("../../common/colors");
const constants_1 = require("../../common/constants");
const default_theme_attributes_1 = require("../../common/default_theme_attributes");
const common_1 = require("../common");
exports.LIGHT_THEME = {
    chartPaddings: theme_common_1.DEFAULT_CHART_PADDING,
    chartMargins: theme_common_1.DEFAULT_CHART_MARGINS,
    lineSeriesStyle: {
        line: {
            visible: true,
            strokeWidth: 1.5,
            opacity: 1,
            focused: { strokeWidth: 2.5 },
            dimmed: {
                strokeWidth: 1,
                stroke: base_colors_1.LIGHT_DIMMED_COLORS.lineStroke,
            },
        },
        point: {
            visible: 'auto',
            strokeWidth: 1.5,
            stroke: common_1.ColorVariant.Series,
            fill: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBasePlain,
            radius: 3,
            opacity: 1,
            focused: { strokeWidth: 2.5 },
            dimmed: {
                stroke: base_colors_1.LIGHT_DIMMED_COLORS.linePointStroke,
                fill: base_colors_1.LIGHT_DIMMED_COLORS.linePointFill,
            },
        },
        isolatedPoint: {
            enabled: true,
            visible: 'auto',
            stroke: common_1.ColorVariant.Series,
            strokeWidth: 1,
            fill: common_1.ColorVariant.Series,
            opacity: 1,
        },
        fit: {
            line: {
                opacity: 1,
                visible: true,
                dash: [5, 5],
                stroke: common_1.ColorVariant.Series,
            },
        },
        pointVisibilityMinDistance: 20,
    },
    bubbleSeriesStyle: {
        point: {
            visible: 'always',
            strokeWidth: 0,
            fill: common_1.ColorVariant.Series,
            radius: 2,
            opacity: 1,
            dimmed: { opacity: 0.25 },
        },
    },
    areaSeriesStyle: {
        area: {
            visible: true,
            opacity: 0.2,
            dimmed: {
                fill: base_colors_1.LIGHT_DIMMED_COLORS.areaFill,
                texture: { opacity: 0.25 },
            },
        },
        line: {
            visible: true,
            strokeWidth: 1.5,
            opacity: 1,
            dimmed: {
                strokeWidth: 1,
                stroke: base_colors_1.LIGHT_DIMMED_COLORS.areaStroke,
            },
            focused: {
                strokeWidth: 2.5,
            },
        },
        point: {
            visible: 'never',
            strokeWidth: 1.5,
            stroke: common_1.ColorVariant.Series,
            fill: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBasePlain,
            radius: 3,
            opacity: 1,
            focused: { strokeWidth: 2.5 },
            dimmed: {
                stroke: base_colors_1.LIGHT_DIMMED_COLORS.areaPointStroke,
                fill: base_colors_1.LIGHT_DIMMED_COLORS.areaPointFill,
            },
        },
        isolatedPoint: {
            enabled: true,
            visible: 'auto',
            stroke: common_1.ColorVariant.Series,
            strokeWidth: 0,
            fill: common_1.ColorVariant.Series,
            opacity: 1,
        },
        fit: {
            line: {
                visible: true,
                dash: [5, 5],
                stroke: common_1.ColorVariant.Series,
                opacity: 1,
            },
            area: {
                visible: true,
                opacity: 0.15,
                fill: common_1.ColorVariant.Series,
            },
        },
        pointVisibilityMinDistance: 20,
    },
    barSeriesStyle: {
        rect: {
            opacity: 1,
        },
        rectBorder: {
            visible: false,
            strokeWidth: 1,
        },
        displayValue: {
            fontSize: 10,
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            alignment: { horizontal: 'center', vertical: 'middle' },
            padding: 0,
            fill: { textBorder: 0 },
            offsetX: 0,
            offsetY: 0,
        },
    },
    arcSeriesStyle: {
        arc: {
            visible: true,
            stroke: colors_1.Colors.Black.keyword,
            strokeWidth: 1,
            opacity: 1,
        },
    },
    sharedStyle: theme_common_1.DEFAULT_GEOMETRY_STYLES,
    scales: {
        barsPadding: 0.25,
        histogramPadding: 0.05,
    },
    axes: {
        axisTitle: {
            visible: true,
            fontSize: 12,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            padding: {
                inner: 10,
                outer: 0,
            },
            fill: base_colors_1.LIGHT_TEXT_COLORS.textParagraph,
        },
        axisPanelTitle: {
            visible: true,
            fontSize: 10,
            fontFamily: 'sans-serif',
            padding: {
                inner: 8,
                outer: 0,
            },
            fill: base_colors_1.LIGHT_TEXT_COLORS.textParagraph,
        },
        axisLine: {
            visible: true,
            stroke: base_colors_1.LIGHT_BORDER_COLORS.borderBaseSubdued,
            strokeWidth: 1,
        },
        tickLabel: {
            visible: true,
            fontSize: 10,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            fill: base_colors_1.LIGHT_TEXT_COLORS.textSubdued,
            padding: { outer: 8, inner: 10 },
            rotation: 0,
            offset: {
                x: 0,
                y: 0,
                reference: 'local',
            },
            alignment: {
                vertical: 'near',
                horizontal: 'near',
            },
        },
        tickLine: {
            visible: false,
            stroke: base_colors_1.LIGHT_BORDER_COLORS.borderBaseSubdued,
            strokeWidth: 1,
            size: 10,
            padding: 10,
        },
        gridLine: {
            horizontal: {
                visible: true,
                stroke: base_colors_1.LIGHT_BORDER_COLORS.borderBaseSubdued,
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
            vertical: {
                visible: true,
                stroke: base_colors_1.LIGHT_BORDER_COLORS.borderBaseSubdued,
                strokeWidth: 1,
                opacity: 1,
                dash: [0, 0],
            },
        },
    },
    colors: {
        vizColors: borealis_colors_1.BOREALIS_COLORS_PALETTE,
        defaultVizColor: '#16C5C0',
    },
    legend: {
        verticalWidth: 200,
        horizontalHeight: 64,
        spacingBuffer: 10,
        margin: 0,
        labelOptions: {
            maxLines: 1,
        },
    },
    crosshair: {
        band: {
            visible: true,
            fill: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBaseInteractiveHover,
        },
        line: {
            visible: true,
            stroke: base_colors_1.LIGHT_BORDER_COLORS.borderStrongPrimary,
            strokeWidth: 1,
            dash: [4, 4],
        },
        crossLine: {
            visible: true,
            stroke: base_colors_1.LIGHT_BORDER_COLORS.borderStrongPrimary,
            strokeWidth: 1,
            dash: [4, 4],
        },
    },
    background: {
        color: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBasePlain,
        fallbackColor: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBasePlain,
    },
    goal: {
        minFontSize: 8,
        maxFontSize: 64,
        maxCircularSize: 360,
        maxBulletSize: 500,
        barThicknessMinSizeRatio: 1 / 10,
        baselineArcThickness: 32,
        baselineBarThickness: 32,
        marginRatio: 0.05,
        maxTickFontSize: 24,
        maxLabelFontSize: 32,
        maxCentralFontSize: 38,
        arcBoxSamplePitch: (5 / 360) * constants_1.TAU,
        capturePad: 16,
        tickLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#646a77',
        },
        majorLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#343741',
        },
        minorLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#646a77',
        },
        majorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#343741',
        },
        minorCenterLabel: {
            fontStyle: 'normal',
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fill: '#646a77',
        },
        targetLine: {
            stroke: '#343741',
        },
        tickLine: {
            stroke: '#98A2B3',
        },
        progressLine: {
            stroke: '#343741',
        },
    },
    partition: {
        outerSizeRatio: 1,
        emptySizeRatio: 0,
        fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
        minFontSize: 8,
        maxFontSize: 16,
        idealFontSizeJump: 1.05,
        maximizeFontSize: false,
        circlePadding: 4,
        radialPadding: constants_1.TAU / 360,
        horizontalTextAngleThreshold: constants_1.TAU / 12,
        horizontalTextEnforcer: 1,
        fillLabel: {
            textColor: common_1.ColorVariant.Adaptive,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            fontVariant: 'normal',
            fontWeight: 400,
            valueFont: {
                fontWeight: 700,
                fontStyle: 'normal',
                fontVariant: 'normal',
            },
            padding: 2,
            clipText: false,
        },
        linkLabel: {
            maximumSection: 10,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontSize: 11,
            fontStyle: 'normal',
            fontVariant: 'normal',
            fontWeight: 400,
            gap: 10,
            spacing: 2,
            horizontalStemLength: 10,
            radiusPadding: 10,
            lineWidth: 1,
            maxCount: 5,
            maxTextLength: 100,
            textColor: base_colors_1.LIGHT_TEXT_COLORS.textParagraph,
            minimumStemLength: 0,
            stemAngle: constants_1.TAU / 8,
            padding: 0,
            valueFont: {
                fontWeight: 400,
                fontStyle: 'normal',
                fontVariant: 'normal',
            },
        },
        sectorLineWidth: 1.5,
        sectorLineStroke: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBasePlain,
    },
    heatmap: {
        brushArea: {
            visible: true,
            stroke: base_colors_1.LIGHT_BORDER_COLORS.borderBasePlain,
            strokeWidth: 2,
        },
        brushMask: {
            visible: true,
            fill: base_colors_1.LIGHT_BACKGROUND_COLORS_CUSTOM.backgroundBasePlainAlpha70,
        },
        brushTool: {
            visible: false,
            fill: base_colors_1.LIGHT_BACKGROUND_COLORS_CUSTOM.backgroundBasePlainAlpha70,
        },
        xAxisLabel: {
            visible: true,
            fontSize: 12,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            textColor: base_colors_1.LIGHT_TEXT_COLORS.textSubdued,
            fontVariant: 'normal',
            fontWeight: 'normal',
            padding: { top: 5, bottom: 5, left: 5, right: 5 },
            rotation: 0,
        },
        yAxisLabel: {
            visible: true,
            width: 'auto',
            fontSize: 12,
            fontFamily: default_theme_attributes_1.DEFAULT_FONT_FAMILY,
            fontStyle: 'normal',
            textColor: base_colors_1.LIGHT_TEXT_COLORS.textSubdued,
            fontVariant: 'normal',
            fontWeight: 'normal',
            padding: { top: 5, bottom: 5, left: 5, right: 5 },
        },
        grid: {
            stroke: {
                width: 1,
                color: base_colors_1.LIGHT_BORDER_COLORS.borderBaseSubdued,
            },
        },
        cell: {
            maxWidth: 'fill',
            maxHeight: 'fill',
            align: 'center',
            label: {
                visible: true,
                maxWidth: 'fill',
                minFontSize: 8,
                maxFontSize: 12,
                fontFamily: 'Sans-Serif',
                fontStyle: 'normal',
                textColor: colors_1.Colors.Black.keyword,
                fontVariant: 'normal',
                fontWeight: 'normal',
                useGlobalMinFontSize: true,
            },
            border: {
                strokeWidth: 0,
                stroke: base_colors_1.LIGHT_BORDER_COLORS.borderBaseSubdued,
            },
        },
    },
    metric: {
        textLightColor: base_colors_1.DARK_TEXT_COLORS.textHeading,
        textSubtitleLightColor: base_colors_1.DARK_TEXT_COLORS.textParagraph,
        textExtraLightColor: base_colors_1.DARK_TEXT_COLORS.textParagraph,
        textDarkColor: base_colors_1.LIGHT_TEXT_COLORS.textHeading,
        textSubtitleDarkColor: base_colors_1.LIGHT_TEXT_COLORS.textParagraph,
        textExtraDarkColor: base_colors_1.LIGHT_TEXT_COLORS.textParagraph,
        valueFontSize: 'default',
        minValueFontSize: 12,
        titlesTextAlign: 'left',
        extraTextAlign: 'right',
        valueTextAlign: 'right',
        valuePosition: 'bottom',
        iconAlign: 'right',
        border: base_colors_1.LIGHT_BORDER_COLORS.borderBaseSubdued,
        barBackground: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBaseDisabled,
        emptyBackground: colors_1.Colors.Transparent.keyword,
        nonFiniteText: 'N/A',
        minHeight: 64,
        titleWeight: 'bold',
    },
    bulletGraph: theme_1.LIGHT_THEME_BULLET_STYLE,
    tooltip: {
        maxWidth: 500,
        maxTableHeight: 120,
        defaultDotColor: colors_1.Colors.Black.keyword,
    },
    flamegraph: {
        navigation: {
            textColor: base_colors_1.LIGHT_TEXT_COLORS.textHeading,
            buttonTextColor: base_colors_1.LIGHT_TEXT_COLORS.textInverse,
            buttonDisabledTextColor: base_colors_1.LIGHT_TEXT_COLORS.textDisabled,
            buttonBackgroundColor: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundFilledPrimary,
            buttonDisabledBackgroundColor: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBaseDisabled,
        },
        scrollbarThumb: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundFilledText,
        scrollbarTrack: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundBaseDisabled,
        minimapFocusBorder: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundFilledAccent,
    },
    highlighter: {
        point: {
            opacity: 1,
            fill: common_1.ColorVariant.Series,
            stroke: common_1.ColorVariant.Series,
            strokeWidth: 1.5,
            radius: 3,
            onHover: {
                opacity: 0.5,
                fill: common_1.ColorVariant.Series,
                stroke: common_1.ColorVariant.None,
                strokeWidth: 0,
                radius: 5,
            },
        },
    },
    lineAnnotation: {
        line: {
            stroke: '#69707D',
            strokeWidth: 1,
            opacity: 1,
        },
    },
    rectAnnotation: {
        strokeWidth: 0,
        opacity: 0.25,
        fill: '#69707D',
        stroke: '#69707D',
    },
    brush: {
        fill: base_colors_1.LIGHT_BACKGROUND_COLORS.backgroundFilledPrimary,
        opacity: 0.1,
        stroke: base_colors_1.LIGHT_BORDER_COLORS.borderStrongPrimary,
        strokeWidth: 1,
    },
};
//# sourceMappingURL=light_theme.js.map