"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.screenspaceMarkerScaleCompressor = void 0;
const screenspaceMarkerScaleCompressor = (domainPositions, itemWidths, outerWidth) => {
    const result = { bounds: [], scaleMultiplier: Infinity };
    const itemCount = Math.min(domainPositions.length, itemWidths.length);
    for (let left = 0; left < itemCount; left++) {
        for (let right = 0; right < itemCount; right++) {
            const domainLeft = domainPositions[left] ?? NaN;
            const domainRight = domainPositions[right] ?? NaN;
            if (domainLeft > domainRight)
                continue;
            const range = outerWidth - (itemWidths[left]?.[0] ?? NaN) - (itemWidths[right]?.[1] ?? NaN);
            const domain = domainRight - domainLeft;
            const scaleMultiplier = range / domain;
            if (scaleMultiplier < result.scaleMultiplier || Number.isNaN(scaleMultiplier)) {
                result.bounds[0] = left;
                result.bounds[1] = right;
                result.scaleMultiplier = scaleMultiplier;
            }
        }
    }
    return result;
};
exports.screenspaceMarkerScaleCompressor = screenspaceMarkerScaleCompressor;
//# sourceMappingURL=screenspace_marker_scale_compressor.js.map