"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrossClusterReplicationHome = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../services/breadcrumbs");
var _routing = require("../../services/routing");
var _auto_follow_pattern_list = require("./auto_follow_pattern_list");
var _follower_indices_list = require("./follower_indices_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/sections/home/home.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CrossClusterReplicationHome extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      activeSection: 'follower_indices'
    });
    (0, _defineProperty2.default)(this, "tabs", [{
      id: 'follower_indices',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.followerIndicesTitle",
        defaultMessage: "Follower indices",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 28,
          columnNumber: 9
        }
      }),
      testSubj: 'followerIndicesTab'
    }, {
      id: 'auto_follow_patterns',
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.autoFollowPatternsTitle",
        defaultMessage: "Auto-follow patterns",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 9
        }
      }),
      testSubj: 'autoFollowPatternsTab'
    }]);
    (0, _defineProperty2.default)(this, "onSectionChange", section => {
      (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)(`/${section}`)]);
      _routing.routing.navigate(`/${section}`);
    });
  }
  componentDidMount() {
    (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)()]);
  }
  static getDerivedStateFromProps(props) {
    const {
      match: {
        params: {
          section
        }
      }
    } = props;
    return {
      activeSection: section
    };
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "appTitle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.crossClusterReplicationTitle",
        defaultMessage: "Cross-Cluster Replication",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 15
        }
      })),
      tabs: this.tabs.map(tab => ({
        onClick: () => this.onSectionChange(tab.id),
        isSelected: tab.id === this.state.activeSection,
        key: tab.id,
        'data-test-subj': tab.testSubj,
        label: tab.name
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: `/follower_indices`,
      component: _follower_indices_list.FollowerIndicesList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      exact: true,
      path: `/auto_follow_patterns`,
      component: _auto_follow_pattern_list.AutoFollowPatternList,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    })));
  }
}
exports.CrossClusterReplicationHome = CrossClusterReplicationHome;