"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Box = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout-components/__stories__/box.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Box = ({
  color,
  backgroundColor,
  rootCSS,
  label,
  children,
  labelCSS
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const rootStyle = (0, _react2.css)`
    background: ${(0, _eui.tint)(backgroundColor, 0.85)};
    display: flex;
    align-items: center;
    justify-content: center;
    height: 100%;
    width: 100%;
    color: ${color};
    position: relative;
    overflow: hidden;
    flex-direction: column;
    gap: ${euiTheme.size.m};

    clip-path: polygon(
      6px 2px,
      calc(100% - 6px) 2px,
      calc(100% - 2px) 6px,
      calc(100% - 2px) calc(100% - 6px),
      calc(100% - 6px) calc(100% - 2px),
      6px calc(100% - 2px),
      2px calc(100% - 6px),
      2px 6px
    );

    &::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      height: 100%;
      width: 100%;
      background: linear-gradient(
        to bottom right,
        transparent 49%,
        ${color} 49%,
        ${color} 51%,
        transparent 51%
      );
      background-size: 8px 8px;
      pointer-events: none;
      z-index: 0;
    }

    & > * {
      z-index: 1;
    }
    ${rootCSS}
  `;
  const labelStyle = (0, _react2.css)`
    color: ${color};
    background: ${(0, _eui.tint)(backgroundColor, 0.85)};
    display: block;
    z-index: 1;
    padding: ${euiTheme.size.s} ${euiTheme.size.m};
    border-radius: ${euiTheme.border.radius.small};
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    ${labelCSS}
  `;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: rootStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: labelStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, label), children);
};
exports.Box = Box;