"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubscriptionNotAllowed = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _test_subjects = require("./test_subjects");
var _use_license_management_locator_api = require("../common/api/use_license_management_locator_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/subscription_not_allowed.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SubscriptionNotAllowed = () => {
  const handleNavigateToLicenseManagement = (0, _use_license_management_locator_api.useLicenseManagementLocatorApi)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    color: "danger",
    alignment: "center",
    "data-test-subj": _test_subjects.SUBSCRIPTION_NOT_ALLOWED_TEST_SUBJECT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.subscriptionNotAllowed.promptTitle",
      defaultMessage: "Upgrade your subscription to an Enterprise license",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 13
      }
    })),
    body: handleNavigateToLicenseManagement ? /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": 'has_locator',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.subscriptionNotAllowed.promptDescription",
      defaultMessage: "To use these cloud security features, you must {link}.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: handleNavigateToLicenseManagement,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 41,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.subscriptionNotAllowed.promptLinkText",
          defaultMessage: "start a trial or upgrade your subscription",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 42,
            columnNumber: 23
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 15
      }
    })) : /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": 'no_locator',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.subscriptionNotAllowed.promptDescriptionNoLocator",
      defaultMessage: "Contact your administrator to change your license.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 7
    }
  }));
};
exports.SubscriptionNotAllowed = SubscriptionNotAllowed;