"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.WorkpadTemplates = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../hooks");
var _workpad_templates = require("./workpad_templates.component");
var _loading = require("../loading");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/workpad_templates/workpad_templates.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkpadTemplates = () => {
  const findTemplates = (0, _hooks.useFindTemplates)();
  const [isMounted, setIsMounted] = (0, _react.useState)(false);
  const [templates, setTemplates] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    const mount = async () => {
      const response = await findTemplates();
      setIsMounted(true);
      setTemplates((response === null || response === void 0 ? void 0 : response.templates) || []);
    };
    mount();
  }, [setIsMounted, findTemplates]);
  const onCreateWorkpad = (0, _hooks.useCreateFromTemplate)();
  if (!isMounted) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_workpad_templates.WorkpadTemplates, {
    templates,
    onCreateWorkpad,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 10
    }
  });
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.WorkpadTemplates = WorkpadTemplates;
var _default = exports.default = WorkpadTemplates;