"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESFieldSelect = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/es_field_select/es_field_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ESFieldSelect = ({
  value,
  fields = [],
  onChange,
  onFocus,
  onBlur
}) => {
  const selectedOption = value ? [{
    label: value
  }] : [];
  const options = fields.map(field => ({
    label: field
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    selectedOptions: selectedOption,
    options: options,
    onChange: ([field]) => {
      var _field$label;
      return onChange((_field$label = field === null || field === void 0 ? void 0 : field.label) !== null && _field$label !== void 0 ? _field$label : null);
    },
    onSearchChange: searchValue => {
      // resets input when user starts typing
      if (searchValue) {
        onChange(null);
      }
    },
    onFocus: onFocus,
    onBlur: onBlur,
    singleSelection: {
      asPlainText: true
    },
    isClearable: false,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.canvas.esFieldSelect.fieldComboBox.ariaLabel', {
      defaultMessage: 'Field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
};
exports.ESFieldSelect = ESFieldSelect;