"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnvironmentsContext = void 0;
exports.EnvironmentsContextProvider = EnvironmentsContextProvider;
var _react = _interopRequireDefault(require("react"));
var _environment_filter_values = require("../../../common/environment_filter_values");
var _use_apm_params = require("../../hooks/use_apm_params");
var _use_environments_fetcher = require("../../hooks/use_environments_fetcher");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_time_range = require("../../hooks/use_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/environments_context/environments_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EnvironmentsContext = exports.EnvironmentsContext = /*#__PURE__*/_react.default.createContext({
  environment: _environment_filter_values.ENVIRONMENT_ALL.value,
  environments: [],
  status: _use_fetcher.FETCH_STATUS.NOT_INITIATED,
  preferredEnvironment: _environment_filter_values.ENVIRONMENT_ALL.value
});
function EnvironmentsContextProvider({
  children,
  customTimeRange
}) {
  const {
    path,
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const serviceName = 'serviceName' in path ? path.serviceName : undefined;
  const environment = 'environment' in query && query.environment || _environment_filter_values.ENVIRONMENT_ALL.value;
  const queryRangeFrom = 'rangeFrom' in query ? query.rangeFrom : undefined;
  const queryRangeTo = 'rangeTo' in query ? query.rangeTo : undefined;
  const rangeFrom = (customTimeRange === null || customTimeRange === void 0 ? void 0 : customTimeRange.rangeFrom) || queryRangeFrom;
  const rangeTo = (customTimeRange === null || customTimeRange === void 0 ? void 0 : customTimeRange.rangeTo) || queryRangeTo;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo,
    optional: true
  });
  const {
    environments,
    status
  } = (0, _use_environments_fetcher.useEnvironmentsFetcher)({
    serviceName,
    start,
    end
  });
  const preferredEnvironment = environment === _environment_filter_values.ENVIRONMENT_ALL.value && environments.length === 1 ? environments[0] : environment;
  return /*#__PURE__*/_react.default.createElement(EnvironmentsContext.Provider, {
    value: {
      environment,
      environments,
      status,
      preferredEnvironment,
      serviceName,
      rangeFrom,
      rangeTo
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, children);
}