"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BORDER_THICKNESS = exports.ACCORDION_PADDING_LEFT = exports.ACCORDION_HEIGHT = void 0;
exports.TraceItemRow = TraceItemRow;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _bar = require("./bar");
var _bar_details = require("./bar_details");
var _toggle_accordion_button = require("./toggle_accordion_button");
var _trace_waterfall_context = require("./trace_waterfall_context");
var _is_failure_or_error = require("./utils/is_failure_or_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/trace_waterfall/trace_item_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACCORDION_PADDING_LEFT = exports.ACCORDION_PADDING_LEFT = 8; // px
const ACCORDION_HEIGHT = exports.ACCORDION_HEIGHT = 48; // px
const BORDER_THICKNESS = exports.BORDER_THICKNESS = 1; // px

function TraceItemRow({
  item,
  childrenCount,
  state,
  onToggle
}) {
  var _item$status;
  const {
    duration,
    margin,
    showAccordion,
    onClick,
    highlightedTraceId
  } = (0, _trace_waterfall_context.useTraceWaterfallContext)();
  const isHighlighted = highlightedTraceId === item.id;
  const widthPercent = item.duration / duration * 100;
  const leftPercent = (item.offset + item.skew) / duration * 100;
  const hasToggle = showAccordion && childrenCount > 0;
  const accordionIndent = ACCORDION_PADDING_LEFT * item.depth;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const itemStatusIsFailureOrError = (0, _is_failure_or_error.isFailureOrError)((_item$status = item.status) === null || _item$status === void 0 ? void 0 : _item$status.value);
  function calculateMarginLeft() {
    const marginLeft = margin.left - accordionIndent - (itemStatusIsFailureOrError ? BORDER_THICKNESS * 2 : BORDER_THICKNESS);
    return hasToggle ? marginLeft - _toggle_accordion_button.TOGGLE_BUTTON_WIDTH : marginLeft;
  }
  const content = /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "traceItemRowWrapper",
    css: (0, _react.css)`
          border-bottom: ${euiTheme.border.thin};
          ${onClick || hasToggle ? 'cursor: pointer;' : 'cursor: default'}
        `,
    onClick: () => {
      if (!hasToggle && onClick) {
        onClick(item.id);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    "data-test-subj": "trace-item-container",
    css: (0, _react.css)`
          margin-left: ${accordionIndent}px;
          margin-right: ${margin.right}px;
          border-left: ${itemStatusIsFailureOrError ? `${euiTheme.border.width.thick} solid ${euiTheme.colors.danger};` : `${euiTheme.border.thin};`}
          padding: 6px 0;
          ${isHighlighted ? `background-color: ${euiTheme.colors.lightestShade};` : undefined}
          ${!highlightedTraceId && ` &:hover {
            background-color: ${euiTheme.colors.lightestShade};
          }`}
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, hasToggle ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_toggle_accordion_button.ToggleAccordionButton, {
    "data-test-subj": "traceItemRowToggleAccordionButton",
    isOpen: state === 'open',
    childrenCount: childrenCount,
    onClick: () => onToggle(item.id),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "traceItemRowContent",
    css: (0, _react.css)`
                margin-left: ${calculateMarginLeft()}px;
              `,
    onClick: () => {
      if (hasToggle && onClick) {
        onClick(item.id);
      }
    },
    onKeyDown: e => {
      if (onClick && (e.key === 'Enter' || e.key === ' ')) {
        // Ignore event if it comes from a link
        if (e.target instanceof HTMLAnchorElement) {
          return;
        }
        e.preventDefault(); // Prevent scroll if Space is pressed
        onClick(item.id);
      }
    },
    tabIndex: onClick ? 0 : -1,
    role: onClick ? 'button' : undefined,
    "aria-label": onClick ? _i18n.i18n.translate('xpack.apm.traceItemRow.openDetailsButton', {
      defaultMessage: 'View details for {name}',
      values: {
        name: item.name
      }
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_bar.Bar, {
    width: widthPercent,
    left: leftPercent,
    color: item.color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_bar_details.BarDetails, {
    item: item,
    left: leftPercent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }))))));
  if (!showAccordion) {
    return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, content);
  }
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    id: item.id,
    buttonContent: content,
    paddingSize: "none",
    forceState: state,
    arrowDisplay: "none",
    buttonContentClassName: "accordion__buttonContent",
    css: (0, _react.css)`
          .accordion__buttonContent {
            width: 100%;
          }
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }));
}