"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeseriesChartWithContext = TimeseriesChartWithContext;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formatters = require("../../../../common/utils/formatters");
var _use_annotations_context = require("../../../context/annotations/use_annotations_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _style = require("../../../utils/style");
var _timezone = require("./helper/timezone");
var _timeseries_chart = require("./timeseries_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeseries_chart_with_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TimeseriesChartWithContext({
  id,
  height = _style.unit * 16,
  fetchStatus,
  onToggleLegend,
  timeseries,
  yLabelFormat,
  yTickFormat,
  showAnnotations = true,
  yDomain,
  anomalyTimeseries,
  customTheme = {}
}) {
  const {
    query: {
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services', '/dependencies/*', '/services/{serviceName}');
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const timeZone = (0, _timezone.getTimeZone)(core.uiSettings);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const annotationColor = euiTheme.colors.accentSecondary;
  const {
    annotations
  } = (0, _use_annotations_context.useAnnotationsContext)();
  const timeseriesAnnotations = [/*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    key: "annotations",
    id: "annotations",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: annotations.map(annotation => ({
      dataValue: annotation['@timestamp'],
      header: (0, _formatters.asAbsoluteDateTime)(annotation['@timestamp']),
      details: `${_i18n.i18n.translate('xpack.apm.chart.annotation.version', {
        defaultMessage: 'Version'
      })} ${annotation.text}`
    })),
    style: {
      line: {
        strokeWidth: 1,
        stroke: annotationColor,
        opacity: 1
      }
    },
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "dot",
      color: annotationColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }),
    markerPosition: _charts.Position.Top,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  })];
  return /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
    id: id,
    height: height,
    fetchStatus: fetchStatus,
    onToggleLegend: onToggleLegend,
    timeseries: timeseries,
    yLabelFormat: yLabelFormat,
    yTickFormat: yTickFormat,
    showAnnotations: showAnnotations,
    annotations: timeseriesAnnotations,
    yDomain: yDomain,
    anomalyTimeseries: anomalyTimeseries,
    customTheme: customTheme,
    timeZone: timeZone,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  });
}