"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerticalLines = VerticalLines;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/timeline/vertical_lines.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function VerticalLines({
  topTraceDuration,
  plotValues,
  marks = []
}) {
  const {
    width,
    margins,
    tickValues,
    xScale
  } = plotValues;
  const markTimes = marks.filter(mark => mark.verticalLine).map(({
    offset
  }) => offset);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const tickPositions = tickValues.reduce((positions, tick) => {
    const position = xScale(tick);
    return Number.isFinite(position) ? [...positions, position] : positions;
  }, []);
  const markPositions = markTimes.reduce((positions, mark) => {
    const position = xScale(mark);
    return Number.isFinite(position) ? [...positions, position] : positions;
  }, []);
  const topTraceDurationPosition = topTraceDuration > 0 ? xScale(topTraceDuration) : NaN;
  return /*#__PURE__*/_react.default.createElement("svg", {
    width: width,
    height: "100%",
    style: {
      position: 'absolute',
      top: 0,
      left: 0
    },
    "data-test-subj": "vertical-lines",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("g", {
    transform: `translate(0 ${margins.top})`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, tickPositions.map((position, index) => /*#__PURE__*/_react.default.createElement("line", {
    key: `tick-${position}-${index}`,
    x1: position,
    x2: position,
    y1: 0,
    y2: "100%",
    stroke: euiTheme.colors.lightestShade,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  })), markPositions.map((position, index) => /*#__PURE__*/_react.default.createElement("line", {
    key: `mark-${position}-${index}`,
    x1: position,
    x2: position,
    y1: 0,
    y2: "100%",
    stroke: euiTheme.colors.mediumShade,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })), Number.isFinite(topTraceDurationPosition) && /*#__PURE__*/_react.default.createElement("line", {
    key: "topTrace",
    x1: topTraceDurationPosition,
    x2: topTraceDurationPosition,
    y1: 0,
    y2: "100%",
    stroke: euiTheme.colors.mediumShade,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  })));
}