"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmMainTemplate = ApmMainTemplate;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _use_default_ai_assistant_starter_prompts_for_apm = require("../../../../hooks/use_default_ai_assistant_starter_prompts_for_apm");
var _environments_context = require("../../../../context/environments_context/environments_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _service_groups = require("../../../app/service_groups");
var _service_groups_button_group = require("../../../app/service_groups/service_groups_button_group");
var _environment_filter = require("../../../shared/environment_filter");
var _no_data_config = require("../no_data_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/templates/apm_main_template/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Paths that must skip the no data screen
const bypassNoDataScreenPaths = ['/settings', '/diagnostics'];

/*
 * This template contains:
 *  - The Shared Observability Nav (https://github.com/elastic/kibana/blob/f7698bd8aa8787d683c728300ba4ca52b202369c/x-pack/plugins/observability/public/components/shared/page_template/README.md)
 *  - The APM Header Action Menu
 *  - Page title
 *
 *  Optionally:
 *   - EnvironmentFilter
 *   - ServiceGroupSaveButton
 */
function ApmMainTemplate({
  pageTitle,
  pageHeader,
  children,
  environmentFilter = true,
  showServiceGroupSaveButton = false,
  showServiceGroupsNav = false,
  selectedNavButton,
  ...pageTemplateProps
}) {
  var _onboardingLocator$us, _pageHeader$pageTitle;
  const location = (0, _reactRouterDom.useLocation)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    docLinks,
    observabilityShared,
    application,
    share
  } = services;
  const onboardingLocator = share === null || share === void 0 ? void 0 : share.url.locators.get(_deeplinksObservability.OBSERVABILITY_ONBOARDING_LOCATOR);
  const addDataUrl = (_onboardingLocator$us = onboardingLocator === null || onboardingLocator === void 0 ? void 0 : onboardingLocator.useUrl({
    category: 'application'
  })) !== null && _onboardingLocator$us !== void 0 ? _onboardingLocator$us : '';
  const ObservabilityPageTemplate = observabilityShared.navigation.PageTemplate;
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/has_data');
  }, []);

  // create static data view on initial load
  (0, _use_fetcher.useFetcher)(callApmApi => {
    const canCreateDataView = application === null || application === void 0 ? void 0 : application.capabilities.savedObjectsManagement.edit;
    if (canCreateDataView) {
      return callApmApi('POST /internal/apm/data_view/static');
    }
  }, [application === null || application === void 0 ? void 0 : application.capabilities.savedObjectsManagement.edit]);
  const shouldBypassNoDataScreen = bypassNoDataScreenPaths.some(path => location.pathname.includes(path));
  const {
    data: fleetApmPoliciesData,
    status: fleetApmPoliciesStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!(data !== null && data !== void 0 && data.hasData) && !shouldBypassNoDataScreen) {
      return callApmApi('GET /internal/apm/fleet/has_apm_policies');
    }
  }, [shouldBypassNoDataScreen, data === null || data === void 0 ? void 0 : data.hasData]);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING || fleetApmPoliciesStatus === _use_fetcher.FETCH_STATUS.LOADING;
  const hasApmData = !!(data !== null && data !== void 0 && data.hasData);
  const hasApmIntegrations = !!(fleetApmPoliciesData !== null && fleetApmPoliciesData !== void 0 && fleetApmPoliciesData.hasApmPolicies);
  const noDataConfig = (0, _no_data_config.getNoDataConfig)({
    docsLink: docLinks.links.observability.guide,
    hasApmData,
    shouldBypassNoDataScreen,
    loading: isLoading,
    addDataUrl
  });
  (0, _use_default_ai_assistant_starter_prompts_for_apm.useDefaultAiAssistantStarterPromptsForAPM)({
    hasApmData,
    hasApmIntegrations,
    noDataConfig
  });
  const rightSideItems = [...(showServiceGroupSaveButton ? [/*#__PURE__*/_react.default.createElement(_service_groups.ServiceGroupSaveButton, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 39
    }
  })] : []), ...(environmentFilter ? [/*#__PURE__*/_react.default.createElement(_environment_filter.ApmEnvironmentFilter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 30
    }
  })] : [])];
  return /*#__PURE__*/_react.default.createElement(_environments_context.EnvironmentsContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, (0, _extends2.default)({
    noDataConfig: shouldBypassNoDataScreen ? undefined : noDataConfig,
    isPageDataLoaded: isLoading === false,
    pageHeader: {
      rightSideItems,
      ...pageHeader,
      pageTitle: (_pageHeader$pageTitle = pageHeader === null || pageHeader === void 0 ? void 0 : pageHeader.pageTitle) !== null && _pageHeader$pageTitle !== void 0 ? _pageHeader$pageTitle : pageTitle,
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showServiceGroupsNav && selectedNavButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_service_groups_button_group.ServiceGroupsButtonGroup, {
        selectedNavButton: selectedNavButton,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 19
        }
      })))
    }
  }, pageTemplateProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }), children));
}