"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeAvailableCard = UpgradeAvailableCard;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _kibana = require("../../../../shared/links/kibana");
var _card_footer_content = require("./card_footer_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/schema/migrated/upgrade_available_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function UpgradeAvailableCard({
  apmPackagePolicyId
}) {
  const upgradeApmPackagePolicyHref = (0, _kibana.useUpgradeApmPackagePolicyHref)(apmPackagePolicyId);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "warning",
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 13
      }
    }),
    title: _i18n.i18n.translate('xpack.apm.settings.schema.upgradeAvailable.title', {
      defaultMessage: 'APM integration upgrade available!'
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.settings.upgradeAvailable.description",
      defaultMessage: "Even though your APM integration is setup, a new version of the APM integration is available for upgrade with your package policy. {upgradePackagePolicyLink} to get the most out of your setup.",
      values: {
        upgradePackagePolicyLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmUpgradeAvailableCardUpgradeYourApmIntegrationLink",
          href: upgradeApmPackagePolicyHref,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.apm.settings.schema.upgradeAvailable.upgradePackagePolicyLink', {
          defaultMessage: 'Upgrade your APM integration'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }),
    footer: /*#__PURE__*/_react.default.createElement(_card_footer_content.CardFooterContent, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
}