"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmOverview = ApmOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _ = require("..");
var _agent_name = require("../../../../../common/agent_name");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _use_time_range = require("../../../../hooks/use_time_range");
var _aggregated_transactions_badge = require("../../../shared/aggregated_transactions_badge");
var _failed_transaction_rate_chart = require("../../../shared/charts/failed_transaction_rate_chart");
var _latency_chart = require("../../../shared/charts/latency_chart");
var _transaction_breakdown_chart = require("../../../shared/charts/transaction_breakdown_chart");
var _transaction_coldstart_rate_chart = require("../../../shared/charts/transaction_coldstart_rate_chart");
var _transactions_table = require("../../../shared/transactions_table");
var _service_overview_dependencies_table = require("../service_overview_dependencies_table");
var _service_overview_errors_table = require("../service_overview_errors_table");
var _service_overview_instances_chart_and_table = require("../service_overview_instances_chart_and_table");
var _service_overview_throughput_chart = require("../service_overview_throughput_chart");
var _slo_callout = require("../../../shared/slo_callout");
var _use_local_storage = require("../../../../hooks/use_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553831493318382/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/apm_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const latencyChartHeight = 200;
function ApmOverview() {
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    serviceName,
    fallbackToTransactions,
    agentName,
    serverlessType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query,
    query: {
      kuery,
      environment,
      rangeFrom,
      rangeTo,
      transactionType
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const [haveTablesLoaded, setHaveTablesLoaded] = (0, _react.useState)({
    transactions: false,
    dependencies: false,
    errors: false
  });
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _react.useEffect)(() => {
    const {
      transactions,
      dependencies,
      errors
    } = haveTablesLoaded;
    if (transactions && dependencies && errors) {
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        }
      });
    }
  }, [haveTablesLoaded, onPageReady, rangeFrom, rangeTo]);
  const isRumAgent = (0, _agent_name.isRumAgentName)(agentName);
  const isOpenTelemetryAgent = (0, _agent_name.isOpenTelemetryAgentName)(agentName);
  const isServerless = (0, _agent_name.isServerlessAgentName)(serverlessType);

  // The default EuiFlexGroup breaks at 768, but we want to break at 1200, so we
  // observe the window width and set the flex directions of rows accordingly
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const isSingleColumn = isLarge;
  const nonLatencyChartHeight = isSingleColumn ? latencyChartHeight : _.chartHeight;
  const rowDirection = isSingleColumn ? 'column' : 'row';
  const [sloCalloutDismissed, setSloCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.sloCalloutDismissed', false);
  const handleOnLoadTable = key => setHaveTablesLoaded(currentValues => ({
    ...currentValues,
    [key]: true
  }));
  const onTransactionsTableLoad = (0, _react.useCallback)(() => handleOnLoadTable('transactions'), []);
  const onErrorsTableLoad = (0, _react.useCallback)(() => handleOnLoadTable('errors'), []);
  const onDependenciesTableLoad = (0, _react.useCallback)(() => handleOnLoadTable('dependencies'), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !sloCalloutDismissed && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_slo_callout.SloCallout, {
    dismissCallout: () => {
      setSloCalloutDismissed(true);
    },
    serviceName: serviceName,
    environment: environment,
    transactionType: transactionType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), fallbackToTransactions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_aggregated_transactions_badge.AggregatedTransactionsBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.LatencyChart, {
    height: latencyChartHeight,
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_throughput_chart.ServiceOverviewThroughputChart, {
    height: nonLatencyChartHeight,
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_transactions_table.TransactionsTable, {
    kuery: kuery,
    environment: environment,
    fixedHeight: true,
    onLoadTable: onTransactionsTableLoad,
    start: start,
    end: end,
    showPerPageOptions: false,
    numberOfTransactionsPerPage: 5,
    showSparkPlots: !isSingleColumn,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, !isRumAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    height: nonLatencyChartHeight,
    showAnnotations: false,
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_errors_table.ServiceOverviewErrorsTable, {
    serviceName: serviceName,
    onLoadTable: onErrorsTableLoad,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 9
    }
  }, isServerless ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_coldstart_rate_chart.TransactionColdstartRateChart, {
    showAnnotations: false,
    environment: environment,
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 15
    }
  })) : !isOpenTelemetryAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_breakdown_chart.TransactionBreakdownChart, {
    showAnnotations: false,
    environment: environment,
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  })), !isRumAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_dependencies_table.ServiceOverviewDependenciesTable, {
    onLoadTable: onDependenciesTableLoad,
    fixedHeight: true,
    showPerPageOptions: false,
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmServiceOverviewViewDependenciesLink",
      href: router.link('/services/{serviceName}/dependencies', {
        path: {
          serviceName
        },
        query
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 21
      }
    }, _i18n.i18n.translate('xpack.apm.serviceOverview.dependenciesTableTabLink', {
      defaultMessage: 'View dependencies'
    })),
    showSparkPlots: !isSingleColumn,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  }))))), !isRumAgent && !isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_instances_chart_and_table.ServiceOverviewInstancesChartAndTable, {
    chartHeight: nonLatencyChartHeight,
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  }))));
}